<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_program', language 'es', version '3.10'.
 *
 * @package     tool_program
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutthefile'] = 'Sobre el archivo';
$string['actions'] = 'Acciones';
$string['active'] = 'Activo';
$string['activeprograms'] = 'Programas activos';
$string['activeprogramslink'] = '<a href="{$a->href}">{$a->count} programas activos</a>';
$string['addcourses'] = 'Agregar cursos';
$string['addcourseslist'] = 'Seleccionar cursos';
$string['addcourseslist_help'] = 'Se pueden seleccionar uno o más cursos.';
$string['addset'] = 'Agregar conjunto';
$string['addsetorcourse'] = 'Agregar un conjunto o un curso';
$string['afterallocationwindowstarts'] = 'Después de que comience la matriculación';
$string['afterallocationwindowstartswithrelativedate'] = '{$a} después de que comience la matriculación';
$string['afterduedate'] = 'Después de la fecha de vencimiento';
$string['afterduedatewithrelativedate'] = '{$a} después de la fecha de vencimiento';
$string['afterstartdate'] = 'Después de la fecha de inicio';
$string['afterstartdatewithrelativedate'] = '{$a} después de la fecha de inicio';
$string['afteruserallocationdate'] = 'Después de la fecha de asignación del usuario';
$string['afteruserallocationdatewithrelativedate'] = '{$a} después de la fecha de asignación del usuario';
$string['all'] = 'Todo';
$string['allinanyorder'] = 'Todo en cualquier orden';
$string['allinorder'] = 'Todo en orden';
$string['allocatetoprogram'] = 'Asignar a programa';
$string['allocateusers'] = 'Asignar usuarios';
$string['allocationdate'] = 'Fecha de asignación';
$string['allocationdateonorafter'] = 'Fecha de asignación en o después de';
$string['allocationenddate'] = 'Fecha de finalización de la asignación';
$string['allocationenddate_help'] = 'Fecha de finalización para asignar usuarios a este programa';
$string['allocationfor'] = 'Asignación para \'{$a}\'';
$string['allocationsource'] = 'Fuente de la asignación';
$string['allocationstartdate'] = 'Fecha de inicio de la asignación';
$string['allocationstartdate_help'] = 'Fecha de inicio para asignar usuarios a este programa';
$string['allocationwindow'] = 'Ventana de asignación';
$string['allocationwindowendedon'] = 'La ventana de asignación para este programa finalizó el {$a}.';
$string['allocationwindowstartson'] = 'La ventana de asignación para este programa comienza el {$a}.';
$string['allowdirectallocation'] = 'Permitir asignación directa';
$string['allowdirectallocation_help'] = 'Permite asignación directo de usuarios en este programa';
$string['archive'] = 'Archivar';
$string['archived'] = 'Archivado';
$string['archivedconfirmation'] = '¿Estás seguro de querer archivar el programa \'{$a}\'? El programa archivado ya no estará disponible para gestores o participantes y sólo se podrá ver en reportes históricos.';
$string['archivedon'] = 'Archivado en';
$string['archivedprograms'] = 'Programas archivados';
$string['assfirstchildof'] = 'Como el primer hijo de "{$ a}"';
$string['associatedcertification'] = 'Certificación asociada';
$string['associatedcertifications'] = 'Certificaciones asociadas';
$string['associatedcertificationswithlinks'] = 'Certificaciones asociadas con links';
$string['atleast'] = 'Al menos';
$string['autocreategroups'] = 'Agregar a grupos del curso';
$string['autocreategroups_help'] = 'Cuando los usuarios están asignados en los cursos del programa, se pueden agregar automáticamente al mismo grupo. En cada curso se creará automáticamente un grupo con el mismo nombre que el programa. Para los cursos que se comparten entre micrositios, el nombre del micrositio también se agregará al nombre del grupo.';
$string['autocreategroupsnone'] = 'No';
$string['autocreategroupsprogram'] = 'Crear grupos para este programa';
$string['availability'] = 'Disponibilidad';
$string['available'] = 'Disponible';
$string['baseset'] = 'Conjunto básico';
$string['beforeenddate'] = 'Antes de la fecha de finalización';
$string['beforeenddatewithrelativedate'] = '{$a} antes de la fecha de finalización';
$string['calendar'] = 'Calendario';
$string['calendarduedate'] = 'Fecha de vencimiento del programa {$a}';
$string['calendarenddate'] = 'Fecha de finalización del programa {$a}';
$string['certification'] = 'Certificación';
$string['certificationduedate'] = 'Fecha de vencimiento de la certificación';
$string['certificationmsgactive'] = 'La certificación <strong>"{$a->fullname}"</strong> debe completarse antes del <strong>{$a->date}</strong>';
$string['certificationmsgcompleted'] = 'La certificación <strong>"{$a->fullname}"</strong> está completada';
$string['certificationmsgcompletedexpired'] = 'Se completó la certificación <strong>"{$a->fullname}"</strong>. Expirará el <strong>{$a->date}</strong>';
$string['certificationmsgduedatenotset'] = 'La certificación <strong>"{$a->fullname}"</strong> no tiene una fecha de vencimiento establecida';
$string['certificationmsgexpired'] = 'La certificación <strong>"{$a->fullname}"</strong> expiró el <strong>{$a->date}</strong>';
$string['certificationmsgoverdue'] = 'La certificación <strong>"{$a->fullname}"</strong> venció el <strong>{$a->date}</strong>';
$string['certifications'] = 'Certificaciones';
$string['close'] = 'Cerrar';
$string['closetoduedate'] = 'Próxima fecha de vencimiento';
$string['collapsed'] = 'Colapsado';
$string['completeallinanyorder'] = 'Completar todo en cualquier orden';
$string['completeallinorder'] = 'Completar todo en orden';
$string['completeatleast'] = 'Completar al menos';
$string['completed'] = 'Completado';
$string['completedprogramslink'] = '<a href="{$a->href}">{$a->count} programas completados </a>';
$string['completion'] = 'Completud';
$string['completion_help'] = 'Tipo de completud a aplicar al conjunto:

* <strong>Todos en orden:</strong> El usuario debe completar todos los cursos en el orden especificado
* <strong>Todos en cualquier orden:</strong> El usuario debe completar todos los cursos en cualquier orden
* <strong>Al menos X:</strong> El usuario debe completar al menos el número de cursos especificado en cualquier orden';
$string['completionatleast'] = 'Completar al menos';
$string['completioncriteria'] = 'Criterio de completud';
$string['completioncriteriagroup'] = 'Completud';
$string['completioncriteriagroup_help'] = 'Por favor, seleccionar un criterio de completud para este conjunto específico';
$string['completiondate'] = 'Fecha de completud';
$string['completiondateonorafter'] = 'Fecha de completud en o después de';
$string['conclusiondate'] = 'Fecha de completud';
$string['conditionprogramcompleted'] = 'Programa completado';
$string['conditionprogramnotcompleted'] = 'Programa no completado';
$string['conditionprogramoverdue'] = 'Programa atrasado';
$string['conditionprogramsuspended'] = 'Programa suspendido';
$string['conditionuserallocated'] = 'Usuarios asignados al programa';
$string['conditionuserallocateddescription'] = 'Usuarios asignados al programa \'{$a}\'';
$string['conditionuserallocateddescriptionwithdate'] = 'Usuarios asignados al programa \'{$a->programname}\'<br />
La asignación es en o después de \'{$a->conditiondate}\'';
$string['conditionusernotallocated'] = 'Usuarios no asignados al programa';
$string['conditionusernotallocateddescription'] = 'Usuarios no asignados al programa \'{$a}\'';
$string['confirmdeallocateusers'] = 'Esta acción eliminará por completo la asignación y los datos asociados para todos los usuarios seleccionados. Esta acción no se puede deshacer.';
$string['confirmdeallocateusersheader'] = 'Desasignar usuarios';
$string['confirmdeletecourse'] = '¿Estás seguro de que deseas eliminar el curso \'{$a}\' del programa?';
$string['confirmdeleteprogram'] = '¿Estás seguro de que deseas eliminar el programa \'{$a}\' y todos los datos asociados? Esta acción no se puede deshacer.';
$string['confirmdeleteset'] = '¿Estás seguro de que deseas eliminar el conjunto \'{$a}\' y quitar los cursos que contiene?';
$string['confirmdeleteuserallocation'] = '¿Estás seguro de que deseas eliminar por completo la asignación del usuario \'{$a}\' y los datos asociados? Esta acción no se puede deshacer.';
$string['confirmduplicate'] = 'Se realizará una copia incluyendo el contenido del programa y su planificación, pero excluyendo a los usuarios. El campo del número de identificación del programa será eliminado.';
$string['containscourse'] = 'Contiene curso';
$string['content'] = 'Contenido';
$string['continue'] = 'Continuar';
$string['copy'] = 'Copiar';
$string['course'] = 'Curso';
$string['coursealreadyinset'] = 'Este curso ya se encuentra en este conjunto';
$string['courseenddate'] = 'Fecha de cierre: {$a}';
$string['courseinformation'] = 'Información de curso';
$string['coursenotavailable'] = 'Curso no disponible';
$string['courses'] = 'Cursos';
$string['coursesinset'] = 'Cursos en conjunto (separados por coma)';
$string['coursesinsetlines'] = 'Cursos en conjunto (uno por línea)';
$string['coursesinsetlineslinks'] = 'Cursos en conjunto con links (uno por línea)';
$string['coursesinsetlinks'] = 'Cursos en conjunto con links (separados por coma)';
$string['coursestartdate'] = 'Fecha de inicio: {$a}';
$string['dateoverriden'] = 'Fecha anulada';
$string['datetypeabsolute'] = 'Seleccionar fecha';
$string['datetypenone'] = 'Sin ajustar';
$string['dayssinceallocation'] = 'Días desde la asignación';
$string['daystakingprogram'] = 'Días tomando el programa';
$string['deallocateusers'] = 'Desasignar usuarios';
$string['default'] = 'Por defecto';
$string['deleteuserallocation'] = 'Borrar asignación del usuario';
$string['description'] = 'Descripción';
$string['directallocationdisabled'] = 'La asignación directa a este programa está deshabilitada';
$string['displaycompletedcourses'] = 'Cursos del programa completados';
$string['displaycompletiondate'] = 'Fecha de completud del programa';
$string['displayprogramduedate'] = 'Fecha de vencimiento del programa';
$string['displayprogramid'] = 'ID interno del programa usado en las URLs';
$string['displayprogramname'] = 'Nombre del programa';
$string['dontchange'] = 'No modificar';
$string['duedate'] = 'Fecha de vencimiento';
$string['duedate_help'] = 'Fecha de vencimiento para este programa';
$string['duedateonorafter'] = 'Fecha de vencimiento en o después';
$string['duplicate'] = 'Duplicar';
$string['dynamic'] = 'Dinámica';
$string['dynamicrules'] = 'Reglas dinámicas';
$string['dynamicrulesplugincheck'] = 'Ver la lista de reglas dinámicas es imposible sin el plugin tool_dynamicrule';
$string['dynamicrulewarningdeallocation'] = 'Los usuarios sólo pueden ser desasignados si fueron asignados por otra regla dinámica, las asignaciones manuales no se verán afectadas.';
$string['editcontent'] = 'Editar contenido';
$string['editdetails'] = 'Editar detalles';
$string['editprogram'] = 'Editar el programa \'{$a}\'';
$string['editprogramname'] = 'Editar el nombre del programa';
$string['editprogramsettings'] = 'Editar ajustes del programa';
$string['editsetname'] = 'Editar el nombre del conjunto';
$string['editstatusanddates'] = 'Editar estado y fechas';
$string['editstatusanddatesbulk'] = 'Editar estado y fechas para múltiples usuarios';
$string['enddate'] = 'Fecha de finalización';
$string['enddate_help'] = 'Fecha de fin para este programa';
$string['enrol'] = 'Asignar';
$string['enrolled'] = 'Asignado';
$string['entityprogram'] = 'Programa';
$string['entityprogramcompletion'] = 'Completud del usuario';
$string['entityprogramcontent'] = 'Contenido del programa';
$string['entityprogramitem'] = 'Ítem del programa';
$string['entityprogramusers'] = 'Asignación de usuario';
$string['errorallocationenddatenostartdate'] = 'La fecha de finalización de la asignación no puede ser una fecha relativa si no se establece la fecha de inicio de la asignación';
$string['errorallocationenddatepreviousstartdate'] = 'La fecha de finalización de la asignación no puede ser anterior a la fecha de inicio de la asignación';
$string['errorbasesetnotfound'] = 'Conjunto base no encontrado';
$string['errorcannotallocate'] = 'No se puede asignar un usuario a un programa (la asignación ya existe o no está permitida)';
$string['errorcannotresetprogram'] = 'No se puede restablecer el programa';
$string['errorcantallocateusers'] = 'No se pueden asignar usuarios';
$string['errorcantcreateset'] = 'No se puede crear el conjunto';
$string['errorcantdeletenotarchivedprogram'] = 'No se puede eliminar un programa que no fue archivado';
$string['errorcantselfenrol'] = 'No se puede auto-asignar';
$string['errorcertificationnotfound'] = 'La certificación no fue encontrada';
$string['errorcouldnotallocate'] = 'No se puede asignar al usuario \'{$a->originaluserfullname}\' al programa \'{$a->program}\'';
$string['errorduedatepreviousstartdate'] = 'La fecha de vencimiento no puede ser anterior a la fecha de inicio';
$string['errorenddatepreviousduedate'] = 'La fecha de fin no puede ser anterior a la fecha de vencimiento';
$string['errorenddatepreviousstartdate'] = 'La fecha de finalización no puede ser anterior a la fecha de inicio';
$string['errorhelperactionnotallowed'] = 'Acción auxiliar no permitida';
$string['erroridnumberuniquetenant'] = 'Este número de ID ya se usa en otro programa';
$string['errorinvaliddate'] = 'Fecha inválida';
$string['errorinvalidprogram'] = 'Programa inválido';
$string['errorinvalidprogramitemmove'] = 'Movimiento de objeto de programa inválido';
$string['errorloadingprogram_mobile'] = 'Error al cargar el programa';
$string['errormissingenrolprogramplugin'] = 'Falta el plugin de inscripción a programas';
$string['errornopermissionallocateusers'] = 'Sin permiso para asignar usuarios al programa';
$string['errornopermissionmanageprograms'] = 'Sin permiso para administrar programas';
$string['errornopermissionmanageusers'] = 'Sin permiso para administrar usuarios';
$string['errornopermissionviewallocatedusers'] = 'Sin permiso para ver los usuarios asignados al programa';
$string['errornopermissionviewprograms'] = 'Sin permiso para ver programas';
$string['errornopermissionviewreports'] = 'Sin permiso para ver reportes';
$string['errornothingtoexportforprograms'] = 'Nada que exportar para los programas compartidos: {$a}';
$string['errorprogramnotfound'] = 'Programa no encontrado';
$string['errorreporttypedoesnotexist'] = 'El tipo de reporte no existe';
$string['errorsameidnumber'] = 'Ya existe un programa con el mismo número de ID';
$string['errorsomeprogramsdontexist'] = 'Algunos programas no existen';
$string['errorusercantbeallocated'] = 'El usuario no puede ser asignado';
$string['eventcourseadded'] = 'Curso agregado';
$string['eventcourseremoved'] = 'Curso removido';
$string['eventcourseupdated'] = 'Curso actualizado';
$string['eventprogramcompleted'] = 'Programa completado';
$string['eventprogramcreated'] = 'Programa creado';
$string['eventprogramdeleted'] = 'Programa eliminado';
$string['eventprogramupdated'] = 'Programa actualizado';
$string['eventsetcompleted'] = 'Conjunto completado';
$string['eventsetcreated'] = 'Conjunto creado';
$string['eventsetdeleted'] = 'Conjunto eliminado';
$string['eventsetupdated'] = 'Conjunto actualizado';
$string['eventuserallocated'] = 'Usuario asignado';
$string['eventuserdeallocated'] = 'Usuario desasignado';
$string['expanded'] = 'Expandido';
$string['export_content'] = 'Ajustes';
$string['export_content_help'] = 'Programas, nombres, descripciones, fechas, etiquetas, etc.';
$string['export_dynamic_rules'] = 'Reglas dinámicas';
$string['export_dynamic_rules_help'] = 'Toda la configuración de las reglas dinámicas para estos programas.';
$string['export_user_allocations'] = 'Asignaciones de usuarios del programa';
$string['export_user_allocations_help'] = 'Incluye asignaciones de usuarios a estos programas. No se incluirá una copia de los propios usuarios.';
$string['exportonlyallocationspostfix'] = '(sólo asignaciones de usuarios)';
$string['exportprogramsdescription'] = 'Programas con sus cursos, asignaciones de usuarios y reglas dinámicas';
$string['futureallocation'] = 'Asignaciones futuras';
$string['gotocourse'] = 'Ir al curso';
$string['gotoprogram'] = 'Ir al programa';
$string['hidden'] = 'Oculto';
$string['idnumber'] = 'Número de ID';
$string['import_content'] = 'Ajustes';
$string['import_content_help'] = 'Programas, nombres, descripciones, fechas, etiquetas, etc.';
$string['import_dynamic_rules'] = 'Reglas dinámicas';
$string['import_dynamic_rules_help'] = 'Toda la configuración de reglas dinámicas para estos programas.';
$string['import_user_allocations'] = 'Asignaciones de usuarios al programa';
$string['import_user_allocations_help'] = 'Incluye asignaciones de usuarios a estos programas.';
$string['importcannotallocate'] = 'No es posible asignar el usuario \'{$a->originaluserfullname}\' al programa \'{$a->program}\', la asignación ya existe o no está permitida';
$string['importlogfailed'] = 'No se pudo importar el programa \'{$a->fullname}\'';
$string['importlogidnumberexists'] = 'El programa con el número de ID \'{$a->originalidnumber}\' ya existe';
$string['importlogsuccess'] = 'Se creó un nuevo programa \'<a href="{$a->url}">{$a->fullname}</a>\' con {$a->setscount} conjuntos, {$a->coursescount} cursos';
$string['importlogsuccessuserallocations'] = 'Usuario asignado \'{$a->userfullname}\' al programa \'{$a->program}\'';
$string['include_shared_entities'] = 'Incluye entidades compartidas';
$string['include_shared_entities_help'] = 'Al habilitar esta opción, el archivo exportado también contendrá:

* Todos los programas compartidos disponibles en el micrositio actual
* Todos los cursos del programa fuera de la categoría de cursos del micrositio actual';
$string['inprogress'] = 'En progreso';
$string['keepprogramdefaults'] = 'Mantener los valores predeterminados del programa';
$string['lastaccessed'] = 'Último acceso';
$string['learning'] = 'Aprendizaje';
$string['lessthanaday'] = 'Menos de un día';
$string['locked'] = 'Bloqueado';
$string['lockedreasonparent'] = 'No está disponible hasta que el conjunto {$a} esté habilitado.';
$string['lockedreasonpreviouscourse'] = 'No está disponible hasta que el curso anterior {$a} esté marcado como completado.';
$string['lockedreasonpreviousset'] = 'No está disponible hasta que el conjunto anterior {$a} esté marcado como completado.';
$string['maincompletion'] = 'Completud principal';
$string['manual'] = 'Manual';
$string['mappingerrorprogramnotfound'] = 'El programa {$a} no fue encontrado';
$string['mappingnoticenoidnumber'] = 'El programa fue localizado por nombre dado que el número de ID estaba vacío. Se recomienda asignar los números de ID a los programas';
$string['messageprovider:programcompleted'] = 'Programa completado';
$string['missingcompletion'] = 'Falta el criterio de finalización';
$string['missingcourse'] = 'Está faltando el curso';
$string['missingfullname'] = 'Está faltando el nombre del programa.';
$string['missingprogram'] = 'Programa no encontrado';
$string['missingsetname'] = 'El nombre del conjunto está faltando';
$string['name'] = 'Nombre';
$string['never'] = 'Nunca';
$string['newnameforset'] = 'Nuevo nombre para \'{$a}\'';
$string['newprogram'] = 'Nuevo programa';
$string['notarchived'] = 'No archivado';
$string['notavailable'] = 'No disponible';
$string['notcompleted'] = 'Sin finalización';
$string['notenrolledprograms_mobile'] = 'No estás matriculado en ningún programa';
$string['notificationduedate'] = 'Este programa vence el {$a}<br /><br />';
$string['notificationprogramuserdeallocated'] = 'Hola {$a->userfullname},<br /><br />
El programa \'{$a->programname}\' se ha cerrado y ya no se puede acceder a él.<br /><br />
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationsubjectprogramcompleted'] = '¡Felicitaciones - \'{$a}\' completo!';
$string['notificationsubjectprogramuserallocated'] = 'Te damos la bienvenida a \'{$a}\'';
$string['notificationsubjectprogramuserdeallocated'] = '\'{$a}\' cerrado';
$string['notset'] = 'Sin ajustar';
$string['notsuspended'] = 'No suspendido';
$string['notvisible'] = 'No visible';
$string['nousersselected'] = 'Necesitás seleccionar al menos un usuario';
$string['numbercoursesinprogramunique'] = 'Cantidad de cursos (único)';
$string['numbercoursesinset'] = 'Cantidad de cursos en el conjunto';
$string['numbercurrentallocatedusers'] = 'Cantidad de usuarios asignados actualmente';
$string['open'] = 'Abierto';
$string['outcomeallocation'] = 'Asignar usuarios a programas';
$string['outcomeallocationdescription'] = 'Asignar usuarios al programa \'{$a}\'<br />
Mantener la fecha de inicio por defecto del programa';
$string['outcomeallocationdescriptionwithdate'] = 'Asignar usuarios al programa \'{$a->programname}\'<br />
Fecha de inicio del programa: \'{$a->startdate}\'';
$string['outcomedeallocation'] = 'Desasignar usuarios de los programas';
$string['outcomedeallocationdescription'] = 'Desasignar usuarios del programa \'{$a}\'';
$string['overdue'] = 'Atrasado';
$string['overdueprogramslink'] = '<a href="{$a->href}">{$a->count} programas atrasados</a>';
$string['parentname'] = 'Nombre del superior';
$string['pending'] = 'Pendiente';
$string['pendingreasonhiddencourse'] = 'Algunos cursos que son requeridos para desbloquear este curso no están disponibles. Por favor, contactate con el administrador del sitio.';
$string['pendingreasonparent'] = 'Se marcará automáticamente como completado cuando: el conjunto {$a} esté disponible.';
$string['pendingreasonpreviouscourse'] = 'Se marcará automáticamente como completado cuando: el curso anterior {$a} esté marcado como completo.';
$string['pendingreasonpreviousset'] = 'Se marcará automáticamente como completado cuando: el conjunto anterior {$a} se marque como completado.';
$string['percentcompleted'] = '{$a}% completado';
$string['pluginname'] = 'Programa';
$string['previewprogramname'] = 'Vista previa del nombre del programa';
$string['privacy:metadata:core_tag'] = 'Etiquetas agregadas a los programas';
$string['privacy:metadata:preference:tool_program_program_status_filter'] = 'Almacena la selección del usuario para el filtro del estado del programa';
$string['privacy:metadata:program_set_completion'] = 'Información sobre la completud de un conjunto de un programa.';
$string['privacy:metadata:program_set_completion:completeddate'] = 'La fecha en la que el usuario completó el conjunto.';
$string['privacy:metadata:program_set_completion:setid'] = 'El conjunto completado.';
$string['privacy:metadata:program_set_completion:timemodified'] = 'La fecha de modificación de la finalización del conjunto.';
$string['privacy:metadata:program_set_completion:userid'] = 'El usuario que completó el conjunto.';
$string['privacy:metadata:program_users'] = 'Información sobre la asignación de usuario al programa.';
$string['privacy:metadata:program_users:allocationtype'] = 'La fuente desde la cual el usuario fue asignado.';
$string['privacy:metadata:program_users:certificationid'] = 'La certificación asignada a (si corresponde).';
$string['privacy:metadata:program_users:duedate'] = 'Fecha de vencimiento del programa.';
$string['privacy:metadata:program_users:duedatelocked'] = 'Si se anula la fecha de vencimiento predeterminada del programa.';
$string['privacy:metadata:program_users:enddate'] = 'Fecha de finalización del programa para este usuario.';
$string['privacy:metadata:program_users:enddatelocked'] = 'Si se anula la fecha de fin predeterminada del programa.';
$string['privacy:metadata:program_users:programid'] = 'El programa asignado a.';
$string['privacy:metadata:program_users:startdate'] = 'Fecha de inicio del programa para este usuario.';
$string['privacy:metadata:program_users:startdatelocked'] = 'Si se anula la fecha de inicio predeterminada del programa.';
$string['privacy:metadata:program_users:status'] = 'Si el usuario ha sido suspendido del programa.';
$string['privacy:metadata:program_users:timemodified'] = 'El horario modificado de la asignación del usuario.';
$string['privacy:metadata:program_users:userid'] = 'El ID del usuario asignado al programa.';
$string['program:allocateuser'] = 'Asignar usuarios a programas';
$string['program:configurecustomfields'] = 'Configurar campos personalizados del programa';
$string['program:coursereset'] = 'Reiniciar los cursos del programa';
$string['program:edit'] = 'Editar programas';
$string['programdescription'] = 'Descripción del programa';
$string['programduedate'] = 'Fecha de vencimiento del programa';
$string['programfullname'] = 'Nombre del programa';
$string['programidnumber'] = 'Número de ID del programa';
$string['programidnumber_help'] = 'El número de ID de un programa sólo se utiliza cuando el programa se empareja con sistemas externos y no se muestra en ninguna parte del sitio. Si el programa tiene un nombre de código oficial se puede ingresar, de lo contrario, el campo se puede dejar en blanco.';
$string['programimage'] = 'Imagen del programa';
$string['programinformation'] = 'Información del programa';
$string['programname'] = 'Nombre del programa';
$string['programnamewithimage'] = 'Nombre del programa con imagen';
$string['programparentsetname'] = 'Nombre del conjunto superior';
$string['programprogress'] = 'Progreso del programa';
$string['programprogresswithreportlinks'] = 'Progreso del programa con links al reporte';
$string['programreset'] = 'Reinicio del programa';
$string['programrules'] = 'Reglas del programa';
$string['programs'] = 'Programas';
$string['programscustomfield'] = 'Campos personalizados de programas';
$string['programsetname'] = 'Nombre del conjunto';
$string['programsoverview_mobile'] = 'Descripción general de los programas';
$string['programstatus'] = 'El estado el programa';
$string['programtags'] = 'Etiquetas del programa';
$string['programtags_help'] = 'Etiquetas para este programa';
$string['programtenant'] = 'Micrositio del programa';
$string['programuserallocations'] = 'Asignación de usuarios al programa';
$string['programvisibility'] = 'Visibilidad del programa';
$string['progressoverview'] = 'Descripción general del progreso';
$string['progresspercent'] = 'Progreso';
$string['progressreport'] = 'Reporte de progreso';
$string['reg_wpprograms'] = 'Cantidad de programas ({$a})';
$string['reportactiveprograms'] = 'Reporte de sistema para programas activos';
$string['reportarchivedprograms'] = 'Reporte de sistema para programas archivados';
$string['reportprogramprogress'] = 'Reporte de sistema para el progreso en los programas';
$string['reportprogramsallocationcompletion'] = 'Asignación de usuarios y completud de los programas';
$string['reportprogramusers'] = 'Reporte de sistema para usuarios de programas';
$string['reportuserprogram'] = 'Reporte de sistema para el progreso en los programas';
$string['reportuserprograms'] = 'Reporte del sistema para la lista de programas de usuario';
$string['reset'] = 'Reiniciar';
$string['resetprogress'] = 'Reiniciar programa';
$string['resetusersprogram'] = 'Reiniciar el programa para los usuarios';
$string['restore'] = 'Restaurar';
$string['review'] = 'Examinar';
$string['rolemanager'] = 'Gestor de programas';
$string['rolemanagerdescription'] = 'Permite crear y administrar programas dentro del micrositio actual y asignarles usuarlos';
$string['scheduleupdatesuccess'] = 'Planificación actualizada satisfactoriamente';
$string['seecontent_mobile'] = 'Ver contenido';
$string['selectactiveandarchivedprograms'] = 'Seleccionar todos los programas activos y archivados';
$string['selectallactiveprograms'] = 'Seleccionar todos los programas activos';
$string['selectallprogramsinthisfile'] = 'Seleccionar todos los programas de este archivo';
$string['selectatleastoneprogram'] = 'Seleccionar al menos un programa';
$string['selectcourses'] = 'Seleccionar cursos';
$string['selectmanually'] = 'Seleccionar manualmente...';
$string['selectprogramcondition'] = 'Programa';
$string['selectprogramcondition_help'] = 'Seleccionar un programa para asociarlo a esta condición';
$string['selectprogramoutcome'] = 'Programa';
$string['selectprogramoutcome_help'] = 'Seleccionar un programa para asociarlo a esta acción';
$string['selectprogramstoallocate'] = 'Programas';
$string['selectprogramstoallocate_help'] = 'Seleccionar los programas en los que los usuarios serán asignados';
$string['separatetenantsingroupswarning'] = 'En cursos compartidos entre micrositios, los usuarios de cada micrositio serán agregados en grupos separados.';
$string['set'] = 'Conjunto';
$string['setname'] = 'Nombre';
$string['setname_help'] = 'Por favor, elegir un nombre para este conjunto';
$string['setsandcoursesnotfound_mobile'] = 'No se encontraron conjuntos o cursos';
$string['start'] = 'Comienzo';
$string['startdate'] = 'Fecha de inicio';
$string['startdate_help'] = 'Fecha de inicio para este programa';
$string['status'] = 'Estado';
$string['status_help'] = 'El estado suspendido implica que se ocultará este programa para este usuario.';
$string['suspended'] = 'Suspendido';
$string['suspendeddateonorafter'] = 'Fecha suspendida en o después';
$string['tagarea_tool_program'] = 'Programas';
$string['tags'] = 'Etiquetas';
$string['timecreated'] = 'Creado el';
$string['timemodified'] = 'Modificado por última vez el';
$string['timesuspended'] = 'Suspendido el';
$string['toomanyprogramstoshow'] = 'Demasiados programas para mostrar';
$string['type'] = 'Tipo';
$string['userduedate'] = 'Fecha de vencimiento';
$string['userduedate_help'] = 'Seleccionar la fecha de vencimiento para este usuario.';
$string['userenddate'] = 'Fecha de cierre';
$string['userenddate_help'] = 'Seleccione la fecha en la que este programa no estará visible para este usuario.';
$string['userlist'] = 'Seleccionar usuarios';
$string['userlist_help'] = 'Seleccionar usuarios para asignarlos a este programa';
$string['users'] = 'Usuarios';
$string['usersallocatedsuccess'] = 'Se crearon con éxito {$a} asignaciones de usuarios';
$string['usersallocationnotavailable'] = 'La asignación de usuarios no está disponible';
$string['usersdeallocatedsuccess'] = '{$a} usuario(s) fueron desasignados satisfactoriamente';
$string['userseditedsuccess'] = '{$a} usuario(s) fueron modificados satisfactoriamente';
$string['usersresetprogramsuccess'] = 'Se reinició el programa para {$a} usuario(s)';
$string['usersskipped'] = '{$a} usuario(s) omitido(s) porque esta opción no está disponible para ellos';
$string['userstartdate'] = 'Fecha de inicio';
$string['userstartdate_help'] = 'Seleccionar la fecha en la que este usuario estará habilitado para comenzar el programa. Esta fecha sólo aplicará para este usuario.';
$string['visible'] = 'Visible';
$string['warningcourseinvisible'] = 'Advertencia: Este curso no es visible para estudiantes.';
