<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_aardvark', language 'es', version '3.10'.
 *
 * @package     theme_aardvark
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['android'] = 'URL de Google Play Store';
$string['androiddesc'] = 'Escriba la URL de su página de Google Play Store (por ejemplo: https://play.google.com/store/apps/developer?id=mycollege)';
$string['apple'] = 'URL de Apple App Store';
$string['appledesc'] = 'Introduzca la URL de su página en la Apple App Store. (algo como https://itunes.apple.com/gb/artist/my-college/id123456789)';
$string['basicheading'] = 'Ajustes básicos';
$string['basicheadingdesc'] = 'Personalizar elementos básicos del tema.';
$string['ceop'] = 'CEOP';
$string['ceopaus'] = 'Habilitar Australia';
$string['ceopdesc'] = 'Habilitar informes CEOP';
$string['ceopnone'] = 'Desactivar';
$string['ceopuk'] = 'Habilitar Reino Unido';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Aardvark</h2>
<p><img class=img-polaroid src="aardvark/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>About</h3>
<p>Aardvark es el tema original basado en menús para Moodle.</p>
<p>Aardvark ha evolucionado con el paso de los años a la vez que el núcleo de Moodle ha ido integrando las características que han hecho a Aardvark tan popular, incluyendo los menús personalizados y de usuario. </p>
<p>El tema cuenta con un aspecto simple inspirado en Flat UI y en material de diseño de Google.</p>
<h3>Padres</h3>
<p>Muchos de los elementos básicos de este tema se basan en Bootstrap y Clean.</p>
<h3>Créditos</h3>
<p>Autor: Shaun Daubney (Newbury College)<br>
Con contribuciones y código base de Bas Brands, David Scotson, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.<br>
Sitio web: <a href="www.newbury-college.ac.uk">Newbury College</a>
</p>
<h3>Informar de un error:</h3>
<p><a href="https://moodle.org/plugins/view.php?plugin=theme_aardvark">https://moodle.org/plugins/view.php?plugin=theme_aardvark</a></p>
<h3>Más información</h3>
<p><a href="aardvark/README.txt">Registro de cambios, licencias e información de versión</a></p>
</div></div>';
$string['configtitle'] = 'Aardvark';
$string['copyright'] = 'Copyright';
$string['copyrightdesc'] = 'El nombre de su organización.';
$string['copyrightlink'] = 'Enlace de Copyright';
$string['copyrightlinkdesc'] = 'La URL del sitio principal de su organización (algo como http://www.mycollege.ac.uk).';
$string['credit'] = 'Basado en un tema original creado por Shaun Daubney';
$string['customcss'] = 'Personalizar CSS';
$string['customcssdesc'] = 'Las reglas CSS que añada en este área de texto se reflejarán en todas las páginas, haciendo más sencilla la personalización de este tema.';
$string['customfooter'] = 'Pie de página por defecto';
$string['customfooterdesc'] = 'El contenido de este área de texto se mostrará en la primera parte/zona del pié de página de todas las páginas.';
$string['disclaimer'] = 'Renuncia';
$string['disclaimerdesc'] = 'El contenido de este área de texto se mostrará en la segunda parte/zona del pié de página de todas las páginas.';
$string['facebook'] = 'URL de Facebook';
$string['facebookdesc'] = 'Introduzca la URL de su página de Facebook. (algo como http://www.facebook.com/mycollege)';
$string['flickr'] = 'URL de Flickr';
$string['flickrdesc'] = 'Introduzca la URL de su página de Flickr. (algo como http://www.flickr.com/mycollege)';
$string['footeroptdesc'] = 'Personalice los elementos básicos del pie de página del tema.';
$string['footeroptheading'] = 'Pie de página';
$string['frontpageheading'] = 'Primera página';
$string['frontpageheadingdesc'] = 'Customice los elementos de la primera página como las alertas de usuario y la fecha.';
$string['generalalert'] = 'Alerta general';
$string['generalalertdesc'] = 'Esto mostrará una alerta en la primera página para avisar a los usuarios de un/a evento/situación en particular.';
$string['googleplus'] = 'URL de Google+';
$string['googleplusdesc'] = 'Introduzca la URL de su perfil de Google+. (algo como http://plus.google.com/107817105228930159735)';
$string['instagram'] = 'URL de Instagram';
$string['instagramdesc'] = 'Introduzca la URL de su página de Instagram (a través de web.stagram). (algo como https://www.instagram.com/mycollege/)';
$string['linkedin'] = 'URL para Linkedln';
$string['linkedindesc'] = 'Escriba la URL para su perfil en Linkednl (por ejemplo: http://www.linkedin.com/compañía/micolegio)';
$string['maincolor'] = 'Color principal';
$string['maincolordesc'] = 'Cambiar el color principal del tema. Esto incluye el color al pasar el ratón encima del menú, encima de la URL y botones.';
$string['pinterest'] = 'URL de Pinterest';
$string['pinterestdesc'] = 'Ingrese la URL de su página de Pinterest. (por ejemplo http://pinterest.com/mi_escuela)';
$string['pluginname'] = 'Aardvark (Oso Hormiguero)';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['sitelogo'] = 'Logo del sitio';
$string['sitename'] = 'Mostrar el nombre del sitio junto con logo pequeño';
$string['sitenamedesc'] = 'Si no hay un logo pequeño, el nombre del sitio siempre se muestra en la barra de navegación. Si se configura un logo pequeño, puede mostarse con o sin el nombre del sitio.';
$string['snapchat'] = 'URL de Snapchat';
$string['snapchatdesc'] = 'Escriba la URL de su perfil de Snapchat. (ejemplo https://www.snapchat.com/add/micolegio)';
$string['socialiconsheading'] = 'Íconos sociales';
$string['socialiconsheadingdesc'] = 'Personalizar íconos de redes sociales.';
$string['twitter'] = 'URL de Twitter';
$string['twitterdesc'] = 'Escriba la URL de su canal de Twitter (ejemplos:  https://twitter.com/UNAM_MX ;  https://twitter.com/IPN_MX ; https://twitter.com/uamx ; https://twitter.com/UVMMEXICO)';
$string['website'] = 'URL del sitio web';
$string['websitedesc'] = 'Escriba la URL de su página web principal (por ejemplo: http://http://www.iztacala.unam.mx/)';
$string['wikipedia'] = 'URL de Wikipedia';
$string['wikipediadesc'] = 'Escriba la URL de su página en la Wikipedia (ejemplos: http://es.wikipedia.org/wiki/UNAM , http://es.wikipedia.org/wiki/IPN , http://es.wikipedia.org/wiki/Universidad_Autónoma_Metropolitana)';
$string['youtube'] = 'URL de YouTube';
$string['youtubedesc'] = 'Escriba la URL de su canal de YouTube  (por ejemplo: http://www.youtube.com/user/unam)';
