<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'reader', language 'es', version '3.10'.
 *
 * @package     reader
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Acción';
$string['actionblockquizzestext'] = 'Usted estará impedido para tomar más exámenes hasta que el profesor quite este bloqueo';
$string['actiondelayquizzestext'] = 'Usted será retrasado para tomar más exámenes hasta que haya pasado el tiempo de espera.';
$string['actionemailstudenttext'] = 'Se le enviará un Email a Usted.';
$string['actionemailteachertext'] = 'Se le enviará un Email al profesor(es) del curso.';
$string['activemessages'] = 'Mensajes activos';
$string['activityoverview'] = 'Haga clic aquí para ver información acerca de su actividad extensiva de lectura';
$string['add'] = 'Añadir';
$string['add_phpdoc'] = 'Añadir comentarios a documentos PHP';
$string['add_phpdoc_desc'] = 'Añadir comentarios PHP doc a archivos php, js y css.';
$string['addbookinstance'] = '<Añadir más libros a este curso';
$string['addmoregoals'] = 'Añadir {no} más metas';
$string['addmorerates'] = 'Añadir {no} valoraciones más';
$string['addonemorerate'] = 'Añadir {no} valoración más';
$string['addquiztoreader'] = 'Añadir exámenes de curso a los exámenes del lector';
$string['adjoiningcomputers'] = 'En computadoras vecinas';
$string['adjustscores'] = 'Ajustar puntajes';
$string['adminarea'] = 'Área administrativa';
$string['all'] = 'Todos';
$string['allbooks'] = 'Descargar/arreglar cubiertas para TODOS los libros disponibles al módulo Lector (Reader)';
$string['allcourses'] = 'Todos los cursos';
$string['alldone'] = 'Todo hecho';
$string['allgroups'] = 'Todos los Grupos';
$string['alllevels'] = 'Todos los niveles';
$string['allowpromotion'] = 'Permitir promocion';
$string['allparticipants'] = 'Todos los participantes';
$string['allterms'] = 'Todos los períodos';
$string['anytime'] = 'En cualquier momento';
$string['anywhere'] = 'En cualquier parte';
$string['arrange'] = 'Arreglar';
$string['assignpointsbookshavenoquizzes'] = 'Otorgar puntos para libros que no tengan exámenes';
$string['atlevel'] = 'en el Nivel';
$string['attemptedbooks'] = 'Descargar/arreglar solamente las cubiertas de libros que hayan sido INTENTADOS en este sitio';
$string['attempts'] = 'Intentos';
$string['attemptsallowedn'] = 'Intentos permitidos: {$a}';
$string['attemptscoremanagement'] = 'Gestión de intento y puntaje';
$string['attemptsupdated'] = '{$a} intentos fueron actualizados';
$string['atttemptsgroupedbybook'] = 'Intentos agrupados por libro';
$string['atttemptsgroupedbyuser'] = 'Intentos agrupados por usuario';
$string['available'] = 'Disponible';
$string['availablefrom'] = 'Disponible desde';
$string['availablefrom_help'] = 'Los estudiantes solamente pueden acceder a esta actividad hasta después de la fecha y hora aquí especificadas. Antes de esta fecha y hora, no estará disponible.';
$string['availableitems'] = 'Ítems disponibles';
$string['availablenolonger'] = 'Lo siento, esta actividad ya no está más disponible.Se cerró en {$a}.';
$string['availablenotyet'] = 'Lo siento, esta actividad todavía no está disponible. Se abrirá en {$a}.';
$string['availableuntil'] = 'Disponible hasta';
$string['availableuntil_help'] = 'Los estudiantes solamente pueden acceder hasta la fecha y hora especificada aquí. Después de esta fecha y hora, ya no estará disponible.';
$string['averageduration'] = 'Duración promedio';
$string['averageduration_help'] = 'La duración promedia de intentos de exámenes en Reader';
$string['averagefailed'] = 'Promedio reprobado';
$string['averagefailed_help'] = 'El número promedio de exámenes de Reader reprobados por estudiante';
$string['averagegrade'] = 'Calificación promedio';
$string['averagegrade_help'] = 'La calificación promedio lograda en exámenes de Reader';
$string['averagepassed'] = 'Promedio aprobatorio';
$string['averagepassed_help'] = 'El número promedio de exámenes de Reader pasados (aprobados) por estudiante';
$string['averagepoints'] = 'Puntos promedio';
$string['averagepointsallterms'] = 'Promedio de puntos (de todos los períodos)';
$string['averagepointsallterms_help'] = 'El número promedio de puntos ganados por cada estudiante en este grupo considerando todos los puntos que cualquiera de ellos ha ganado alguna vez en cualquier actividad de Reader en este sitio Moodle.';
$string['averagepointsthisterm'] = 'Promedio de puntos (de este período)';
$string['averagepointsthisterm_help'] = 'El número promedio de puntos ganados por cada estudiante en este grupo considerando solamente puntos ganados en esta actividad de Reader durante el período actual.';
$string['averagerating'] = 'Valoración (rating) promedio';
$string['averagetaken'] = 'Promedio tomado';
$string['averagetaken_help'] = 'El número promedio de exámenes de Reader tomados por estudiante';
$string['averagewords'] = 'Promedio de palabras';
$string['averagewordsallterms'] = 'Promedio de palabras (de todos los períodos)';
$string['averagewordsallterms_help'] = 'El número promedio de palabras ganados por cada estudiante en este grupo considerando todas las palabras que cualquiera de ellos ha ganado alguna vez en cualquier actividad de Reader en este sitio Moodle.';
$string['averagewordsthisterm'] = 'Promedio de palabras (de este período)';
$string['averagewordsthisterm_help'] = 'El número promedio de palabras ganados por cada estudiante en este grupo considerando solamente palabras ganadas en esta actividad de Reader durante el período actual.';
$string['awardbookpoints'] = 'Dar créditos por libros a estudiantes seleccionados';
$string['awardextrapoints'] = 'Otorgar créditos extra a alumnos seleccionados';
$string['awardpointsmanually'] = 'No hay examen para este libro. En su lugar, por favor pídale a su profesorque otorgue los puntos/palabras manualmente.';
$string['best'] = 'El mejor';
$string['blockquizattempts'] = 'Bloquear sguientes intentos de examen';
$string['book'] = 'Libro';
$string['bookadded'] = 'Libro añadido: {$a}';
$string['bookcovers'] = 'Mostrar portadas de los libros';
$string['bookdifficulty'] = 'Dificultad del libro';
$string['bookeditdetails'] = 'Editar detalles del libro';
$string['bookhasnoquiz'] = 'Este libro no tiene examen';
$string['bookinstances'] = 'Usar subconjunto de exámenes';
$string['bookinstancesdisabled'] = 'Esta actividad de Lector (Reader) no está usando un sub-conjunto de exámenes, por lo que no requiere entradas en la tabla de book_instances';
$string['booklevelmanagement'] = 'Gestión del Libro y Nivel';
$string['booknotadded'] = 'Libro NO añadido: {$a}';
$string['booknotfound'] = 'Libro no encontrado {$a}';
$string['booknotupdated'] = 'Libro no actualizado {$a}';
$string['bookquiznumber'] = 'Número de examen de libro';
$string['bookrating'] = 'Valoración (rating) de libro';
$string['bookrating0'] = 'No me gustó nadita';
$string['bookrating1'] = 'Estuvo más o menos';
$string['bookrating2'] = 'Estuvo bueno';
$string['bookrating3'] = 'Estuvo muy bueno';
$string['bookratingslevel'] = 'Mostrar valuaciones (ratings) de libro por estudiantes para cada nivel de libro';
$string['books'] = 'Libros';
$string['booksaddbook'] = 'Añadir libro nuevo';
$string['booksallwith'] = 'cualquier libro que haya sido leído al menos una vez';
$string['booksavailable'] = '{$a}libro(s) disponible(s)';
$string['booksavailableall'] = 'todos los libros disponibles';
$string['booksavailablewith'] = 'libros disponibles que hayan sido leídos al menos una vez';
$string['booksavailablewithout'] = 'libros disponibles que todavía no hayan sido leídos';
$string['bookseditcourse'] = 'Editar ibros (Curso)';
$string['bookseditcourse_help'] = 'En esta página, Usted puede espeecificar cuales libros de Reader van a hacerse disponibles en este curso. Adicionalmente Usted especifica el nivel y el número de palabras para esos libros. Si un nivel o un número de palabras no es especificado aquí, entonces será usado el valor por defecto para ese libro en este sitio Moodle.';
$string['bookseditsite'] = 'Editar libros (Sitio)';
$string['bookseditsite_help'] = 'En esta página Usted puede configurar añadir, editar y eliminar información acerca de libros Reader en este sitio Moodle. Tenga en cuenta que los valores aquí configurados para cualquier libro serán remplazados si se vuelven a descargar los datos para ese libro desde el sitio web principal de Moodle Reader. También, los valores pueden ser anulados localente en cursos individuales.';
$string['booksreadinpreviousterms'] = 'Libros leidos en períodos anteriores';
$string['booksreadsincedate'] = 'Libros leídos desde {$a}';
$string['booksreadsincepromotion'] = 'Libros leídos desde su promoción en {$a}';
$string['booksreadthisterm'] = 'Libros leidos en este período';
$string['booksviaapi'] = 'Datos del libro (vía API)';
$string['bookswithoutquizzes'] = 'Libros sin exámenes';
$string['bookswithquizzes'] = 'Libros con exámenes';
$string['booktitle'] = 'Título del libro';
$string['booktype'] = 'Libros a incluir';
$string['bookupdated'] = 'Libro actualizado: {$a}';
$string['cannotaccesscourse'] = 'Lo sentimos, Usted no tiene permiso para gestionar actividades en el "{$a}" curso.';
$string['cannotcreatecourse'] = 'Lo siento, no puede realizarse la descarga porque Usted no tiene los permisos para crear un nuevo curso o para editar el curso actual.';
$string['cannotdownloadata'] = 'Lo siento, hubo un problema al descargar datos desde el módulo de Lector';
$string['changeallstoplevelto'] = 'Cambiar todos los niveles máximos a';
$string['changeallto'] = 'Cambiar todo a';
$string['changecurrentlevel'] = 'Cambiar todos losniveles actuales a';
$string['changedifficultyfrom'] = 'Cambiar los niveles de dificultad de';
$string['changelevelfrom'] = 'Cambiar nombre del nivel de';
$string['changenumberofsectionsinquiz'] = 'Reiniciar número de secciones en el curso de repositorio de libros';
$string['changepointsfrom'] = 'Cambiar puntos de';
$string['changepublisherfrom'] = 'Cambiar el nombre de la editorial de';
$string['changequiz'] = 'Cambiar examen';
$string['changereaderlevel'] = 'Cambiar Nivel de Lectura, Longitud o Número de Palabras';
$string['changestartlevel'] = 'Cambiar todos los niveles de inicio a';
$string['cheated'] = 'Hizo trampa';
$string['cheatedmessage'] = 'Mensaje de trampa';
$string['cheatedmessage_help'] = 'Este mensaje se les enviará a los estudiantes que el módulo Lector juzgue que han hecho trampa.';
$string['cheatedshort'] = 'Tra';
$string['cheatsheet'] = 'Hoja de trampa';
$string['check_email'] = 'Revisar Email';
$string['check_email_desc'] = 'Enviar dos Emails de prueba al usuario gueststudent, uno vía Moodle mail y otro vía PHP mail.';
$string['checkbox'] = 'Mostrar casillas de selección';
$string['checkcheating'] = 'Revisar si hizo trampa';
$string['checkonlythiscourse'] = 'Revisar solamente este curso';
$string['checksuspiciousactivity'] = 'Revisar bitácoras para buscar actividad sospechosa';
$string['chooseaction'] = 'Elegir una acción y hacer clic en "Ir"';
$string['choosedifficulty'] = 'Por favor elija el nivel de lectura';
$string['chooselevel'] = 'Por favor elija nivel';
$string['choosepublisher'] = 'Por favor elija editorial';
$string['clearedmessage'] = 'Mensaje exonerado';
$string['clearedmessage_help'] = 'Este mensaje es enviado a los estudiantes que fueron juzgados por el módulo Lector como que hicieron trampa, pero después fueron exonerados por el profesor.';
$string['clicktocontinue'] = 'Elija aquí para continuar';
$string['complete'] = 'Completo';
$string['completequizattempt'] = 'Antes de que Usted pueda tomar más exámenes nuevos, Usted debe terminar este examen para "{$a}". Haga clic en el enlace inferior para continuar su intento anterior de este examen.';
$string['completionpass'] = 'Requerir calificación aprobatoria';
$string['completiontotalwords'] = 'Requerir total de lectura';
$string['completiontotalwords_help'] = 'El total de lectura que un estudiante debe lograr dentro de esta actividad para que sea marcada como completa.';
$string['configmreaderenable'] = 'Habilitar o deshabilitar las configuraciones para mReader.org';
$string['configmreadersiteid'] = 'La ID numérica debajo de la cual está registrado este sitio Moodle en mReader.org';
$string['configmreadersitekey'] = 'La clave secreta que le permite a los estudiantes de este sitio Moodle acceder a exámenes en mReader.org';
$string['configmreaderurl'] = 'La URL en donde los estudiantes pueden acceder a los exámenes en mReader.org';
$string['configserverpassword'] = 'La contraseña necesaria para descargar exámenes de Moodle Reader para este sitio Moodle.';
$string['configserverurl'] = 'La URL desde donde Usted puede descargar exámenes Moodle Reader para este sitio Moodle.';
$string['configserverusername'] = 'El nombre_de_usuario necesario para descargar exámenes Moodle Reader para este sitio Moodle.';
$string['confirmdeleteattempts'] = '¿Desea realmente borrar estos intentos?';
$string['confirmstartattemptlimit'] = 'Número de intentos permitidos: {$a}. Está a punto de comenzar un nuevo intento. ¿Desea continuar?';
$string['confirmstartattempttimelimit'] = 'Este cuestionario tiene un límite de tiempo y está restringido a {$a} intento(s). Está a punto de comenzar un nuevo intento. ¿Desea continuar?';
$string['confirmstarttimelimit'] = 'Este cuestionario tiene un límite de tiempo. ¿Está seguro de querer empezar?';
$string['countactive'] = 'Alumnos activos';
$string['countactive_help'] = 'El número de alumnos que han realizado al menos un cuestionario de lectura.';
$string['countfailed'] = 'Cuestionarios fallidos';
$string['countinactive'] = 'Alumnos inactivos';
$string['countinactive_help'] = 'Número de alumnos que no han realizado ningún cuestionario de lectura.';
$string['countpassed'] = 'Cuestionarios superados';
$string['countrating'] = 'Número de valoraciones';
$string['courseid'] = 'ID del Curso';
$string['coursespecificquizselection'] = 'Selección de examen específica-del-curso a "Si" en la pantalla de configuración del módulo.';
$string['createcoversets_l'] = 'Crear Conjuntos de Forros por  Nivel y Editorial';
$string['createcoversets_t'] = 'Crear Conjuntos de Forros por Editorial &amp; Nivel';
$string['credit'] = 'Crédito extra';
$string['creditshort'] = 'X';
$string['curlerror'] = 'Error CURL: {$a}';
$string['current'] = 'Actual';
$string['currentcourse'] = 'Curso actual';
$string['currentlevel'] = 'Nivel actual';
$string['dataallavailable'] = 'la información para el/los {$a} libro(s) está disponible';
$string['dataalldownloaded'] = 'la información para el/los {$a} libro(s) se ha descargado';
$string['datasomeavailable'] = 'la información para {$a->new} del total de {$a->all} libro(s) está disponible';
$string['defaultcategoryname'] = 'Cuestionarios de lectura';
$string['defaultcoursename'] = 'Cuestionarios de lectura';
$string['defaultgoal'] = 'Objetivo por defecto';
$string['defaultgoals'] = 'Objetivos por defecto';
$string['defaultquestioncategoryinfo'] = '{$a->category} preguntas para el {$a->quiz}';
$string['defaultrates'] = 'Calificaciones por defecto';
$string['definelogindetails'] = 'Por favor defina los detalles de inicio de sesión: {$a}';
$string['delayineffect'] = 'El aplazamiento de cuestionario está activo';
$string['delayquizattempts'] = 'Aplazar futuros intentos de cuestionario';
$string['delete'] = 'Eliminar';
$string['deleteallattempts'] = 'Eliminar todos los intentos de los cuestionarios de lectura';
$string['deleteallattempts_help'] = 'Por norma general, NO debería borrar intentos de cuestionarios de lectura.

Sólo debería eliminar intentos si está completamente seguro de que los alumnos de este curso no volverán a realizar cuestionarios de lectura en este sitio Moodle jamás.

Esto se debe a que eliminando los intentos de los cuestionarios de lectura, permite a los alumnos volver a hacer cualquier cuestionario de lectura que ya hubieran realizado antes. Esta NO es la forma en la que se desea que funcione el módulo Lector. Los alumnos deberían tener sólo UNA oportunidad de hacer cada cuestionario de lectura.

Eliminar intentos de los cuestionarios de lectura también reseteará las puntuaciones de lecturas de todos los alumnos a cero, lo que probablemente no quiera ni usted ni los alumnos.';
$string['deleteattempts'] = 'Eliminar los intentos seleccionados';
$string['deletecategories'] = 'Eliminar categorías';
$string['deletecourses'] = 'Eliminar cursos';
$string['deleted'] = 'Eliminado';
$string['deletedshort'] = 'Eli';
$string['deletegoals'] = 'Eliminar los objetivos para grupos y niveles';
$string['deletegoals_help'] = 'Los objetivos de lectura por defecto para grupos o los niveles de lectura serán eliminados.';
$string['deletemessages'] = 'Eliminar los mensajes del módulo Lector';
$string['deletemessages_help'] = 'Todos los mensajes que aparecen en la página principal de los alumnos de este curso sobre actividades de lectura serán eliminados.';
$string['deleterates'] = 'Eliminar calificaciones para grupos y niveles';
$string['deleterates_help'] = 'Las calificaciones de los cuestionarios de lectura para grupos o niveles de lectura serán eliminados.';
$string['detect_cheating'] = 'Se detectó trampa';
$string['detect_cheating_desc'] = 'Revisar las bitácoras de intentos y reportar actividad sospechosa que podría indicar que hicieron trampa.';
$string['difficulty'] = 'Dificultad';
$string['difficultyshort'] = 'RL';
$string['disallowpromotion'] = 'NO permitir ascensos';
$string['displayoptions'] = 'Mostrar opciones';
$string['downloadbooksviaapi'] = 'Descargar datos del libro (vía API)';
$string['downloadbookswithoutquizzes'] = 'Descargar información del libro (sin cuestionarios)';
$string['downloadbookswithquizzes'] = 'Descargar información del libro y cuestionarios';
$string['downloadedbooks'] = 'Se descargó la información de los siguiente libros:';
$string['downloadexcel'] = 'Descargar Excel';
$string['downloadextrapoints'] = 'Por favor descargue los cuestionarios "Puntos Extra"';
$string['downloadmode'] = 'Modo';
$string['downloadmode_help'] = 'Esta página puede presentarse de dos modos:

**Normal**
: En el modo normal, sólo estarán disponibles los libros cuya información aún no se haya descargado o los libros cuya información se haya actualizado. Los libros para los que se haya descargado información más reciente no estarán disponibles.

**Reparar**
: En el modo reparar, todos los libros están disponibles para descargar. Si alguna información se ha descargado anteriormente será sobre escrita por la nueva información descargada. Utilice este modo si quiere reparar cuestionarios defectuosos o información incorrecta. Tenga en cuenta que aunque los cuestionarios también serán sobre escritos, la información de los intentos de los alumnos en esos cuestionarios se mantendrá.';
$string['downloads'] = 'Descargar';
$string['downloadsettings'] = 'Descargar ajustes';
$string['duration'] = 'Duración';
$string['edit'] = 'Editar';
$string['editquiztoreader'] = 'Eliminar cuestionarios';
$string['err_regex_float'] = 'Este valor debe ser un número decimal entre 0,0 y 10,0';
$string['err_regex_integer'] = 'Este valor debe ser un número entero entre 0 y 100.000';
$string['error'] = 'Error: {$a}';
$string['errorsfound'] = 'Errores encontrados';
$string['event_attempt_added'] = 'Intento de examen de Reader añadido';
$string['event_attempt_added_description'] = 'El usuario con id "{$a->userid}" inició un intento de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_attempt_added_explanation'] = 'Un usuario recientemente empezó un intento de examen de Reader';
$string['event_attempt_deleted'] = 'Intento de examen de Lector eliminado';
$string['event_attempt_deleted_description'] = 'El usuario con id "{$a->userid}" eliminó un intento de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_attempt_deleted_explanation'] = 'Un usuario recientemente eliminó un intento de un examen de Lector';
$string['event_attempt_edited'] = 'Intento de examen de Lector eliminado';
$string['event_attempt_edited_description'] = 'El usuario con id "{$a->userid}" editó un intento de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_attempt_edited_explanation'] = 'Un usuario recientemente ha editado un intento de un examen de Lector';
$string['event_attempt_submitted'] = 'Intento de examen de Lector enviado';
$string['event_attempt_submitted_description'] = 'El usuario con id "{$a->userid}" envió un intento de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_attempt_submitted_explanation'] = 'Un usuario recientemente envió un intento de un examen de Lector';
$string['event_base'] = 'Evento de Lector detectado';
$string['event_base_description'] = 'El usuario con id "{$a->userid}" inició un evento en la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_base_explanation'] = 'Un evento fue detectadopor el módulo de Lector';
$string['event_book_added'] = 'Libro de Lector añadido';
$string['event_book_added_description'] = 'El usuario con id "{$a->userid}" añadió un libro para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_book_added_explanation'] = 'Un usuario recientemente añadió datos acerca de un libro de Reader';
$string['event_book_deleted'] = 'Libro de Lector eliminado';
$string['event_book_deleted_description'] = 'El usuario con id "{$a->userid}" eleminó un libro para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_book_deleted_explanation'] = 'Un usuario recientemente eliminó datos de un libro de Reader';
$string['event_book_edited'] = 'Libro de lector editado';
$string['event_book_edited_description'] = 'El usuario con id "{$a->userid}" editó un libro para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_book_edited_explanation'] = 'Un usuario recientemente editó datos de un libro de Reader';
$string['event_books_downloaded'] = 'Libros de Lector descargados';
$string['event_books_downloaded_description'] = 'El usuario con id "{$a->userid}" descargó libros para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_books_downloaded_explanation'] = 'Un usuario recientemente descargó datos de libros de Reader';
$string['event_cron_run'] = 'Cron de Lector ejecutado';
$string['event_cron_run_description'] = 'El trabajo del CRON del Lector ha corrido';
$string['event_cron_run_explanation'] = 'El trabajo del CRON del Lector recientemente ha sido corrido';
$string['event_downloads_viewed'] = 'Descargas de Lector vistas';
$string['event_downloads_viewed_description'] = 'El usuario con id "{$a->userid}" avió datos acerca de las descargas para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_downloads_viewed_explanation'] = 'Un usuario recientemente vió datos de descargas de Reader';
$string['event_message_added'] = 'Mensaje de Reader añadido';
$string['event_message_added_description'] = 'El usuario con id "{$a->userid}" añadió un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_message_added_explanation'] = 'Un usuario recientemente añadió un mensaje a una actividad de Reader';
$string['event_message_deleted'] = 'Mensaje de Reader eliminado';
$string['event_message_deleted_description'] = 'El usuario con id "{$a->userid}" eliminó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_message_deleted_explanation'] = 'Un usuario recientemente eliminó un mensaje de una actividad de Reader';
$string['event_message_edited'] = 'Mensaje de Reader editado';
$string['event_message_edited_description'] = 'El usuario con id "{$a->userid}" editó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_message_edited_explanation'] = 'Un usuario recientemente editó un mensaje de una actividad de Reader';
$string['event_quiz_added'] = 'Examen de Reader añadido';
$string['event_quiz_added_description'] = 'El usuario con id "{$a->userid}" añadió un examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_added_explanation'] = 'Un usuario recientemente añadió un examen a una actividad de Reader';
$string['event_quiz_delay_set'] = 'Retraso de examen de Reader configurado';
$string['event_quiz_delay_set_description'] = 'El usuario con id "{$a->userid}" configuró un retraso de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_delay_set_explanation'] = 'Un usuario recientemente configuró un retraso en un examen de Reader';
$string['event_quiz_deleted'] = 'Examen de Reader eliminado';
$string['event_quiz_deleted_description'] = 'El usuario con id "{$a->userid}" eliminó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_deleted_explanation'] = 'Un usuario recientemente eliminó un examen de Reader';
$string['event_quiz_edited'] = 'Examen de Reader editado';
$string['event_quiz_edited_description'] = 'El usuario con id "{$a->userid}" editó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_edited_explanation'] = 'Un usuario recientemente editó un examen de Reader';
$string['event_quiz_finished'] = 'Examen de lector terminado';
$string['event_quiz_finished_description'] = 'El usuario con id "{$a->userid}" terminó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_finished_explanation'] = 'Un usuario recientemente terminó un examen de Reader';
$string['event_quiz_selected'] = 'Examen de lector seleccionado';
$string['event_quiz_selected_description'] = 'El usuario con id "{$a->userid}" seleccionó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_selected_explanation'] = 'Un usuario recientemente seleccionó un examen de Reader';
$string['event_quiz_started'] = 'Examen de Lector iniciado';
$string['event_quiz_started_description'] = 'El usuario con id "{$a->userid}" inició un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_started_explanation'] = 'Un usuario recientemente inició un examen de Reader';
$string['event_report_bookdetailed_viewed'] = 'Reporte de Reader visto: Libros (detallado)';
$string['event_report_bookdetailed_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Libros" (detallado) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_bookdetailed_viewed_explanation'] = 'Un usuario recientemente vió un Reporte de Reader: Libros (detallado)';
$string['event_report_booksummary_viewed'] = 'Reporte de Reader visto: Libros (resumen)';
$string['event_report_booksummary_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Libros" (resumen) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_booksummary_viewed_explanation'] = 'Un usuario recientemente vió un reporte de Reader: Libros (resumen)';
$string['event_report_groups_viewed'] = 'Reporte de Reader visto: Grupos (resumen)';
$string['event_report_groups_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Grupos" (resumen) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_groups_viewed_explanation'] = 'Un usuario recientemente vió un reporte de Reader: Grupos (resumen)';
$string['event_report_userdetailed_viewed'] = 'Reporte de Reader visto: Usuarios (detallado)';
$string['event_report_userdetailed_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Usuarios" (detallado) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_userdetailed_viewed_explanation'] = 'Un usuario recientemente vió un reporte de Reader: Usuarios (detallado)';
$string['event_report_usersummary_viewed'] = 'Reporte de Reader visto: Usuarios (resumen)';
$string['event_report_usersummary_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Usuarios" (resumen) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_usersummary_viewed_explanation'] = 'Un usuario recientemente vió un reporte de Reader: Usuarios (resumen)';
$string['event_tool_run'] = 'Herramienta administrativa del Lector corrida';
$string['event_tool_run_description'] = 'El usuario con id "{$a->userid}" corrió una herramienta administrativa para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_tool_run_explanation'] = 'Un usuario recientemente corrió una herramienta de Reader: {$a}';
$string['event_user_goal_set'] = 'Meta de usuario Lector configurada';
$string['event_user_goal_set_description'] = 'El usuario con id "{$a->userid}" configuró una meta de lectura de estudiante para la actividad de "Lector" con la ID del módulo de curso "{$a->cmid}"';
$string['event_user_goal_set_explanation'] = 'Un usuario acaba de configurar una meta de lectura en una actividad de Lector';
$string['event_user_level_set'] = 'Nivel de usuario Lector configurado';
$string['event_user_level_set_description'] = 'El usuario con id "{$a->userid}" configuró un nivel de lectura de estudiante para la actividad "reader" con ID de módulo de curso  "{$a->cmid}"';
$string['event_user_level_set_explanation'] = 'Un usuario recientemente configuró el nivel de lectura para un estudiante en una actividad de Reader';
$string['event_users_exported'] = 'Usuarios de Reader exportados';
$string['event_users_exported_description'] = 'El usuario con id "{$a->userid}" exportó datos de estudiante para la actividad "reader" con ID del módulo de curso  "{$a->cmid}"';
$string['event_users_exported_explanation'] = 'Un usuario recientemente exportó datos de estudiantes desde una actividad de Reader';
$string['event_users_imported'] = 'Usuarios de Reader importados';
$string['event_users_imported_description'] = 'El usuario con id "{$a->userid}" importó datos de estudiante para la actividad "reader" con ID del módulo de curso  "{$a->cmid}"';
$string['event_users_imported_explanation'] = 'Un usuario recientemente importó datos de estudiantes hacia una actividad de Reader';
$string['export'] = 'Exportar';
$string['export_reader_tables'] = 'Exportar tablas de Lector';
$string['export_reader_tables_desc'] = 'Exportar tablas de base de datos de Reader. Tenga en cuenta que los datos exportados no contienen nombres de usuario ni de curso, solamente IDs.';
$string['exportstudentrecords'] = 'Exportar registros de estudiante';
$string['extrapoints'] = 'Puntos Extra';
$string['extrapoints0'] = '0.5 Puntos';
$string['extrapoints1'] = '1 Punto';
$string['extrapoints2'] = '2 Puntos';
$string['extrapoints3'] = '3 Puntos';
$string['extrapoints4'] = '4 Puntos';
$string['extrapoints5'] = '5 Puntos';
$string['extrapoints6'] = '6 Puntos';
$string['extrawords'] = '{$a} palabras';
$string['failed'] = 'Reprobó';
$string['failedshort'] = 'NA';
$string['filename'] = 'Nombre del archivo';
$string['fileuploaded'] = 'El archivo fue subido';
$string['find_faultyquizzes'] = 'Encontrar exámenes defectuosos';
$string['find_faultyquizzes_desc'] = 'Encontrar exámenes que tengan preguntas que no tengan respuesta correcta, o preguntas que se hayan vuelto huérfanas.';
$string['finishreview'] = 'Terminar Revisión';
$string['fix_bookcovers'] = 'Reparar Portadas de libros';
$string['fix_bookcovers_desc'] = 'Detectar libros a los que les falta una imagen de cubierta-de-libro, e intentar descargar la imagen de cubierta del libro.';
$string['fix_bookinstances'] = 'Reparar instancias de libros';
$string['fix_bookinstances_desc'] = 'Asegurarse de que todos los libros tengan un registro asociado en la tabla reader_book_instances.';
$string['fix_coursesections'] = 'Reparar secciones de curso';
$string['fixattempts'] = 'Corrigiendo intentos de lectura duplicados';
$string['fixcontexts'] = 'Corrigiendo los contextos defectuosos en categorías de pregunta del Examen';
$string['fixingsumgrades'] = 'Reparando calificaciones en intentos de exámenes de Reader...';
$string['hidden'] = 'Oculto';
$string['modulename_link'] = 'mod/reader/view';
$string['notavailable'] = 'Este cuestionario no está disponible actualmente';
$string['nothavepermissioncreateinstance'] = 'Lo siento, no tiene permiso para realizar esta acción';
$string['numberofextrapoints'] = 'Número de puntos extra';
$string['onlybookswithmorethan'] = 'Solo libros con más de';
$string['passworderror'] = 'La contraseña introducida es incorrecta';
$string['passwords_list'] = 'Lista de contraseñas';
$string['pleaseaskyourinstructor'] = 'Por favor pida a su instructor que le suba de nivel si es demasiado fácil para usted.';
$string['pleaseclose'] = 'Su petición ha sido procesada. Puede cerrar ya esta ventana';
$string['pleasewait'] = 'Por favor espere';
$string['points'] = 'Puntos';
$string['popup'] = 'Usar ventana "segura"';
$string['quiznotavailable'] = 'Lo sentimos, este cuestionario actualmente no está disponible para usted';
$string['sectiontypehidden'] = 'Una sección oculta';
$string['show'] = 'Mostrar';
$string['showall'] = 'Mostrar Todo';
$string['showdeleted'] = 'Mostrar intentos borrados';
$string['showhidden'] = 'Mostrar libros ocultos';
$string['showhide'] = 'Mostrar/Ocultar';
$string['showhidebook'] = 'Mostrar u ocultar';
$string['showprogressbar'] = 'Mostrar barra de progreso';
$string['showwordcount'] = 'Mostrar solo el contador de palabras';
$string['wordsorpoints'] = 'Mostrar palabras o puntos';
