<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'es', version '3.10'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Control de acceso';
$string['actionaftercorrectanswer'] = 'Acción posterior a la respuesta correcta';
$string['actionaftercorrectanswer_help'] = 'Después de contestar correctamente una pregunta, hay 3 opciones para la página siguiente:

* Normal - Se sigue el itinerario de la lección
* Mostrar una página no vista  - Las páginas se muestran en un orden aleatorio, sin que ninguna página se muestre dos veces
* Mostrar una página aún no respondida - Las páginas se muestran en un orden aleatorio, de manera que las páginas que contienen preguntas sin respuesta se muestra de nuevo';
$string['actions'] = 'Acciones';
$string['activitylink'] = 'Enlace a la siguiente actividad';
$string['activitylink_help'] = 'Para proporcionar un enlace al final de la lección a otra actividad del curso, seleccione la actividad en el menú desplegable.';
$string['activitylinkname'] = 'Ir a {$a}';
$string['activityoverview'] = 'Tiene lecciones vencidas';
$string['addabranchtable'] = 'Añadir una página de contenido';
$string['addanendofbranch'] = 'Añadir un final de ramificación';
$string['addanewpage'] = 'Añadir una nueva página';
$string['addaquestionpage'] = 'Añadir una página de pregunta';
$string['addaquestionpagehere'] = 'Añadir aquí una página de pregunta';
$string['addbranchtable'] = 'Añadir una página de contenido';
$string['addcluster'] = 'Añadir un clúster';
$string['addedabranchtable'] = 'Añadida una página de contenido';
$string['addedanendofbranch'] = 'Añadido un final de ramificación';
$string['addedaquestionpage'] = 'Añadida una página de preguntas';
$string['addedcluster'] = 'Añadido un clúster';
$string['addedendofcluster'] = 'Añadido un final de clúster';
$string['addendofbranch'] = 'Añadir un final de ramificación';
$string['addendofcluster'] = 'Añadir un final de clúster';
$string['addessay'] = 'Crear una página de pregunta ensayo';
$string['additionalattemptsremaining'] = 'Finalizado, puede volver a realizar un intento en esta lección';
$string['addmatching'] = 'Crear una página de pregunta de emparejamiento';
$string['addmultichoice'] = 'Crear una página de pregunta de opción múltiple';
$string['addnewgroupoverride'] = 'Añadir excepción de grupo';
$string['addnewuseroverride'] = 'Añadir excepción de usuario';
$string['addnumerical'] = 'Crear una página de pregunta numérica';
$string['addpage'] = 'Añadir una página';
$string['addshortanswer'] = 'Crear una página de pregunta de respuesta corta';
$string['addtruefalse'] = 'Crear una página de pregunta verdadero/falso';
$string['allotheranswers'] = 'Todas las demás respuestas';
$string['allotheranswersjump'] = 'Todas las demás respuestas saltan';
$string['allotheranswersscore'] = 'Todas las demás respuestas puntúan';
$string['allowofflineattempts'] = 'Permitir realizar la lección fuera de línea utilizando la aplicación móvil';
$string['allowofflineattempts_help'] = 'Si se habilita, el usuario de la aplicación móvil puede descargarse la lección y realizarla fuera de línea. Todas las posibles respuestas y respuestas correctas también serán descargadas. Nota: No es posible realizar la lección fuera de línea si tiene límite de tiempo.';
$string['anchortitle'] = 'Comienzo del contenido principal';
$string['and'] = 'Y';
$string['answer'] = 'Respuesta';
$string['answeredcorrectly'] = 'respondidas correctamente.';
$string['answersfornumerical'] = 'Las respuestas a preguntas numéricas deberían ser pares de valores máximo y mínimo';
$string['arrangebuttonshorizontally'] = '¿Disponer horizontalmente los botones de contenido?';
$string['attempt'] = 'Intento: {$a}';
$string['attemptheader'] = 'Intento';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Intentos';
$string['attemptsdeleted'] = 'Intentos eliminados';
$string['attemptsremaining'] = 'Tiene {$a} intento(s) pendiente(s)';
$string['available'] = 'Disponible desde';
$string['averagescore'] = 'Puntuación promedio';
$string['averagetime'] = 'Tiempo promedio';
$string['branch'] = 'Contenido';
$string['branchtable'] = 'Contenido';
$string['cancel'] = 'Cancelar';
$string['cannotfindanswer'] = 'Error: no se pudo encontrar la respuesta';
$string['cannotfindattempt'] = 'Error: no se pudo encontrar el intento';
$string['cannotfindessay'] = 'Error: no se pudo encontrar el ensayo';
$string['cannotfindfirstgrade'] = 'Error: no se pudieron encontrar las calificaciones';
$string['cannotfindfirstpage'] = 'No se pudo encontrar la primera página';
$string['cannotfindgrade'] = 'Error: no se pudieron encontrar las calificaciones';
$string['cannotfindnewestgrade'] = 'Error: no se puede encontrar la calificación más reciente';
$string['cannotfindnextpage'] = 'Retroalimentación de la lección: no se pudo encontrar la Página Siguiente';
$string['cannotfindpagerecord'] = 'Añadir un final de ramificación: registro de página no encontrado';
$string['cannotfindpages'] = 'No se han encontrado páginas en la lección';
$string['cannotfindpagetitle'] = 'Confirmar eliminación: título de página no encontrado';
$string['cannotfindpreattempt'] = 'No se ha encontrado el registro de intento previo';
$string['cannotfindrecords'] = 'Error: no se pudieron encontrar los registros de la lección';
$string['cannotfindtimer'] = 'Error: no se pudieron encontrar los registros de lesson_timer';
$string['cannotfinduser'] = 'Error: no se pudieron encontrar los usuarios';
$string['canretake'] = 'Permitir que el {$a} pueda retomar la lección';
$string['casesensitive'] = 'Usar expresiones regulares';
$string['casesensitive_help'] = '<p>Algunos tipos de pregunta tienen una opción que se activa con un clic en cuadro de verificación.  Los tipos de la pregunta y el significado de las opciones son detallados abajo.

<ol>
<li><p><b>Elección múltiple</b> Es una variante de las preguntas de Opción
Múltiple llamada de <b>&quot;Elección múltiple y respuestas múltiples"</b>.  Si escoge esta opción en la pregunta entonces requieren que el estudiante seleccione todas las respuestas correctas del conjunto de respuestas.  La pregunta puede o no decir al estudiante <i>cuántas</i> respuestas correctas existen. Por ejemplo "¿Cuáles han sido presidentes de
EE.UU.?", o "Seleccione a dos presidentes de EE.UU. de la siguiente lista.".  El número de respuestas correctas pueden ser de <b>una</b> hasta todas las opciones.  (Una pregunta de Elección múltiples y respuestas múltiples con una respuesta correcta <b>es</b> diferente de una pregunta de Opción Múltiple pues la primera permite al estudiante la posibilidad de elegir más de una respuesta mientras que la última no lo permite.)</p></li>

<li><p><b>Respuesta corta</b> Por defecto, en las comparaciones no se tiene en cuenta si el texto está mayúsculas o minúsculas. Si se selecciona Opción de pregunta  las comparaciones tiene en cuenta si el texto está en mayúsculas o minúsculas.</p></li>

<p>En los otros tipos de preguntas no afecta la Opción de pregunta.</p>';
$string['checkbranchtable'] = 'Comprobar página de contenidos';
$string['checkedthisone'] = 'Eligieron esta.';
$string['checknavigation'] = 'Revisar navegación';
$string['checkquestion'] = 'Revisar pregunta';
$string['classstats'] = 'Estadísticas de clase';
$string['clicktodownload'] = 'Haga clic en el siguiente enlace para descargar el archivo.';
$string['closebeforeopen'] = 'No se ha podido actualizar la lección. Ha especificado una fecha de cierre anterior a la fecha de apertura.';
$string['cluster'] = 'Racimo (cluster)';
$string['clusterjump'] = 'Pregunta no vista dentro de un cluster';
$string['clustertitle'] = 'Cluster';
$string['collapsed'] = 'Colapsado';
$string['comments'] = 'Sus comentarios';
$string['completed'] = 'Finalizado';
$string['completederror'] = 'Completar la lección';
$string['completethefollowingconditions'] = 'Para seguir, deberá completar la(s) siguiente(s) condición(es) en la lección <b>{$a}</b>.';
$string['completionendreached'] = 'Obligatorio llegar al final';
$string['completionendreached_desc'] = 'El estudiante deberá llegar al final de la página de la lección para completar esta actividad';
$string['completiontimespent'] = 'El estudiante deberá realizar esta actividad al menos durante';
$string['completiontimespentdesc'] = 'El estudiante deberá realizar esta actividad durante al menos {$a}';
$string['completiontimespentgroup'] = 'Tiempo necesario invertido';
$string['conditionsfordependency'] = 'Condición(es) para la dependencia';
$string['configintro'] = 'Los valores fijados aquí definen los valores por defecto que se utilizan en los ajustes del formulario cuando se crea una nueva actividad de lección. Los ajustes especificados como avanzados sólo se muestran cuando se hace clic en el enlace \'Mostrar más...\'.';
$string['configmaxanswers'] = 'Número máximo de respuestas por página predeterminado';
$string['configmediaclose'] = 'Muestra un botón de cierre en el marco de la ventana emergente generada por un archivo multimedia vinculado';
$string['configmediaheight'] = 'Establece la altura de la ventana emergente para mostrar un archivo multimedia enlazado';
$string['configmediawidth'] = 'Establece el ancho de la ventana emergente para mostrar un archivo multimedia enlazado.';
$string['configpassword_desc'] = 'Si se requiere una contraseña para acceder a la lección.';
$string['configslideshowbgcolor'] = 'Color de fondo para la presentación de diapositivas si está habilitado';
$string['configslideshowheight'] = 'Establece la altura de la presentación de diapositivas si está habilitado';
$string['configslideshowwidth'] = 'Establece el ancho de la presentación de diapositivas si está habilitado';
$string['configtimelimit_desc'] = 'Si se establece un tiempo límite, se muestra un aviso al principio de la lección y habrá un temporizador de cuenta atrás. Si se establece en cero, no hay tiempo límite.';
$string['confirmdelete'] = 'Eliminar página';
$string['confirmdeletionofthispage'] = 'Confirme que desea eliminar esta página';
$string['congratulations'] = 'Enhorabuena, ha llegado al final de la lección';
$string['continue'] = 'Continuar';
$string['continuetoanswer'] = 'Continuar en cambiar respuestas.';
$string['continuetonextpage'] = 'Continuar en la página siguiente';
$string['correctanswerjump'] = 'Salto a respuesta correcta';
$string['correctanswerscore'] = 'Puntuación de respuesta correcta';
$string['correctresponse'] = 'Comentario (correcto)';
$string['createaquestionpage'] = 'Crear una página de preguntas';
$string['credit'] = 'Crédito';
$string['customscoring'] = 'Puntuación personalizada';
$string['customscoring_help'] = 'Si está habilitada, se puede dar a cada respuesta una puntuación numérica (positiva o negativa).';
$string['deadline'] = 'Fecha final';
$string['defaultessayresponse'] = 'Su ensayo será calificado por su profesor.';
$string['deleteallattempts'] = 'Eliminar todos los intentos de resolver la lección';
$string['deletedefaults'] = 'Eliminada {$a} x lección por defecto';
$string['deletedpage'] = 'Página eliminada';
$string['deletepagenamed'] = 'Borrar página: {$a}';
$string['deleting'] = 'Eliminando';
$string['deletingpage'] = 'Eliminando página: {$a}';
$string['dependencyon'] = 'Dependiente de';
$string['dependencyon_help'] = '<p>Esta opción permite que la lección actual dependa del rendimiento de los estudiantes en otra lección del         mismo curso. Si no alcanza el rendimiento exigido, el estudiante no podrá acceder a esta lección.</p>

<p>Las condiciones de la dependencia incluyen:
    <ul>
        <li><b>Tiempo empleado:</b> el estudiante debe emplear en la lección el tiempo que aquí se señale.</li>
        <li><b>Completa:</b> el estudiante debe completar la lección.</li>
        <li><b>Calificación superior a:</b> el estudiante debe alcanzar en la lección una calificación superior     a la especificada en esta opción.</li>
    </ul>
    Puede usarse cualquier combinación de las opciones anteriores.
</p>';
$string['description'] = 'Descripción';
$string['deselectallattempts'] = 'Anular selección de todos los intentos';
$string['detailedstats'] = 'Estadísticas detalladas';
$string['didnotanswerquestion'] = 'No ha contestado a esta pregunta.';
$string['didnotreceivecredit'] = 'No ha recibido crédito';
$string['disabled'] = 'Desactivado';
$string['displaydefaultfeedback'] = 'Usar retroalimentación por defecto';
$string['displaydefaultfeedback_help'] = '<p align="center"><strong>Mostrar retroalimentación por defecto</strong></p>

<p>Si se ajusta esta opción a <strong>Sí</strong>, cuando no se encuentre una respuesta a una pregunta en particular, se usará por defecto el comentario "Esa es la respuesta correcta" y "Esa es la respuesta incorrecta".</p>
<p>Si la opción se ajusta a <strong>No</strong>, cuando no se encuentre una respuesta a una pregunta en particular, no se mostrarán comentarios de retroalimentación. El usuario que está realizando la lección pasará directamente a la siguiente página de la lección.</p>';
$string['displayinleftmenu'] = '¿Mostrar en el menú?';
$string['displayleftif'] = 'Calificación mínima para mostrar el menú';
$string['displayleftif_help'] = 'Esta configuración determina si un estudiante debe obtener una cierta puntuación para poder ver el menú de la lección. Esto obliga al estudiante a pasar por toda la lección en su primer intento y así obtener la puntuación necesaria para poder utilizar el menú de la izquierda para la revisión.';
$string['displayleftmenu'] = 'Mostrar menú';
$string['displayleftmenu_help'] = 'Si está habilitada, se mostrará a los usuarios un menú de navegación con la lista de páginas.';
$string['displayofgrade'] = 'Mostrar calificación (sólo para estudiantes)';
$string['displayreview'] = 'Proporcionar una opción para tratar de nuevo la pregunta';
$string['displayreview_help'] = 'Si está habilitado, cuando una pregunta se responde incorrectamente, el estudiante tiene la opción de volver a intentarlo sin crédito de puntos o continuar con la lección. Si el alumno hace clic para pasar a otra pregunta, se almacenará la respuesta seleccionada (incorrecta). De forma predeterminada, los saltos de respuesta incorrecta se establecen a "esta página" y tienen una puntuación de 0, por lo que se recomienda que establezca la respuesta incorrecta para saltar a una página diferente para evitar confusiones con sus alumnos.';
$string['displayscorewithessays'] = '<p>Usted ha obtenido un total de {$a->score} sobre {$a->tempmaxgrade} en las preguntas calificadas de manera automática.<p>
<p>Sus {$a->essayquestions} pregunta(s) de ensayo se calificarán  se añadirán a su calificación final.<p>
<p>Su calificación actual sin incluir  las pregunta(s) ensayo es de {$a->score} sobre {$a->grade}.<p>';
$string['displayscorewithoutessays'] = 'Su puntuación es {$a->score} (sobre {$a->grade}).';
$string['duplicatepagenamed'] = 'Duplicar página: {$a}';
$string['edit'] = 'Edición';
$string['editbranchtable'] = 'Editando una página de contenido';
$string['editcluster'] = 'Editando un clúster';
$string['editendofbranch'] = 'Editando una página de final de ramificación';
$string['editendofcluster'] = 'Editando una página de final de clúster';
$string['editessay'] = 'Editando una página de pregunta ensayo';
$string['editingquestionpage'] = 'Editando página de preguntas {$a}';
$string['editlessonsettings'] = 'Editar los ajustes de Esta lección';
$string['editmatching'] = 'Editando una página de pregunta de emparejamiento';
$string['editmultichoice'] = 'Editando una página de pregunta de opción múltiple';
$string['editnumerical'] = 'Editando una página de pregunta numérica';
$string['editoverride'] = 'Editar excepción';
$string['editpage'] = 'Modificar el contenido de la página';
$string['editpagecontent'] = 'Editar el contenido de esta página';
$string['editquestion'] = 'Editando una página de pregunta';
$string['editshortanswer'] = 'Editando una página de pregunta de respuesta corta';
$string['edittruefalse'] = 'Editando una página de pregunta verdadero/falso';
$string['email'] = 'Email';
$string['emailallgradedessays'] = 'Enviar por correo electrónico TODOS los ensayos calificados';
$string['emailgradedessays'] = 'Enviar por email los ensayos calificados';
$string['emailsuccess'] = 'Email enviado con éxito';
$string['emptypassword'] = 'La contraseña no puede estar vacía';
$string['enabled'] = 'Activado';
$string['endofbranch'] = 'Fin de ramificación';
$string['endofcluster'] = 'Final de cluster';
$string['endofclustertitle'] = 'Fin de cluster';
$string['endoflesson'] = 'Fin de la lección';
$string['enteredthis'] = 'introducido ésta.';
$string['enterpassword'] = 'Por favor, escriba la contraseña:';
$string['eolstudentoutoftime'] = 'Atención: Usted ha sobrepasado el tiempo fijado para esta lección. Su última respuesta puede no haber sido contabilizada si ha sido dada con el tiempo finalizado.';
$string['eolstudentoutoftimenoanswers'] = 'No ha contestado a ninguna pregunta. En esta lección ha obtenido 0 puntos.';
$string['essay'] = 'Ensayo';
$string['essayemailmessage2'] = '<p>Mensaje de ensayo: {$a->question}</p><p>Su respuesta: <em>{$a->response}</em></p><p>Comentarios del evaluador: <em>{$a->comment}</em></p><p>Ha recibido {$a->earned} de {$a->outof} en esta pregunta de ensayo.</p><p>Su calificación en la lección {$a->lesson} ha cambiado a {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p>Ha recibido {$a->earned} de {$a->outof} en esta pregunta de ensayo.</p><p>Su calificación en la lección {$a->lesson} ha cambiado a {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Calificación disponible para las preguntas de la lección';
$string['essaynotgradedyet'] = 'Este ensayo aún no ha sido calificado';
$string['essayresponses'] = 'Respuestas de los ensayos';
$string['essays'] = 'Ensayos';
$string['essayscore'] = 'Puntuación del ensayo';
$string['eventcontentpageviewed'] = 'Página de contenidos visualizada';
$string['eventessayassessed'] = 'Ensayo evaluado';
$string['eventessayattemptviewed'] = 'Intento del ensayo visualizado';
$string['eventhighscoreadded'] = 'Puntuación más alta de la lección añadida';
$string['eventhighscoresviewed'] = 'Resultados más altos de la lección visualizados';
$string['eventlessonended'] = 'Lección finalizada';
$string['eventlessonrestarted'] = 'Lección reiniciada';
$string['eventlessonresumed'] = 'Lección reanudada';
$string['eventlessonstarted'] = 'Lección comenzada';
$string['eventoverridecreated'] = 'Se ha creado la excepción de la lección';
$string['eventoverridedeleted'] = 'Se ha eliminado la excepción de la lección';
$string['eventoverrideupdated'] = 'Se ha actualizado la excepción de la lección';
$string['eventpagecreated'] = 'Página creada';
$string['eventpagedeleted'] = 'Página borrada';
$string['eventpagemoved'] = 'Página trasladada';
$string['eventpageupdated'] = 'Página actualizada';
$string['eventquestionanswered'] = 'Pregunta respondida';
$string['eventquestionviewed'] = 'Pregunta visualizada';
$string['false'] = 'Falso';
$string['fileformat'] = 'Formato de archivo';
$string['finalwrong'] = 'No exactamente.';
$string['finish'] = 'Terminado';
$string['firstanswershould'] = 'de elementos';
$string['firstwrong'] = 'Su respuesta es incorrecta. ¿Desea intentarlo de nuevo? ( si contesta la pregunta correctamente no se tomará en cuenta en la puntuación final)';
$string['flowcontrol'] = 'Control de Flujo';
$string['fractionsaddwrong'] = 'Las calificaciones positivas otorgadas no suman 100% sino {$a}%<br />¿Desea regresar y corregir esta pregunta?';
$string['fractionsnomax'] = 'Una de las preguntas debe ser 100% para que sea<br />posible alcanzar la calificación máxima<br />¿Desea regresar y corregir esta pregunta?';
$string['full'] = 'Expandido';
$string['general'] = 'General';
$string['gotoendoflesson'] = 'Ir al final de la lección';
$string['grade'] = 'Calificación';
$string['gradebetterthan'] = 'Calificación superior a (%)';
$string['gradebetterthanerror'] = 'Obtener una calificación superior al {$a} por ciento';
$string['graded'] = 'Calificado';
$string['gradeessay'] = 'Calificar preguntas de ensayo ({$a->notgradedcount} no calificadas y {$a->notsentcount} no enviadas)';
$string['gradeis'] = 'La calificación es {$a}';
$string['gradeoptions'] = 'Opciones de Calificación';
$string['groupoverrides'] = 'Excepciones de grupo';
$string['groupoverridesdeleted'] = 'Excepciones de grupo eliminadas';
$string['groupsnone'] = 'No hay grupos a los que pueda acceder.';
$string['handlingofretakes'] = 'Calificación con varios intentos';
$string['handlingofretakes_help'] = 'Si se permite repetir la lección, este ajuste especifica si la calificación de la lección es la media o máxima de todos los intentos.';
$string['havenotgradedyet'] = 'Aún no calificado.';
$string['here'] = 'aquí';
$string['highscore'] = 'Puntuación alta';
$string['hightime'] = 'Tiempo alto';
$string['importcount'] = 'Importando {$a} preguntas';
$string['importquestions'] = 'Importar preguntas';
$string['importquestions_help'] = 'Esta función permite importar preguntas de diferentes formatos mediante archivos de texto,';
$string['inactiveoverridehelp'] = '* Esta anulación está inactiva porque el acceso del usuario a la actividad está restringido. Esto puede deberse a asignaciones de roles o grupos, otras restricciones de acceso o que la actividad está oculta.';
$string['indicator:cognitivedepth'] = 'Lección cognitiva';
$string['indicator:cognitivedepth_help'] = 'Este indicador está basado en la profundidad cognitiva alcanzada por el estudiante en una actividad Lección.';
$string['indicator:cognitivedepthdef'] = 'Lección cognitiva';
$string['indicator:cognitivedepthdef_help'] = 'El participante ha alcanzado este porcentaje del compromiso cognitivo ofrecido por las actividades de Lección durante este intervalo de análisis (Niveles = Sin visualización, Ver, Enviar, Ver comentarios, Comentar comentarios, Reenviar después de ver comentarios)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Lección social';
$string['indicator:socialbreadth_help'] = 'Este indicador está basado en la amplitud social alcanzada por el estudiante en una actividad Lección.';
$string['indicator:socialbreadthdef'] = 'Lección social';
$string['indicator:socialbreadthdef_help'] = 'El participante ha alcanzado este porcentaje del compromiso social ofrecido por las actividades de Lección durante este intervalo de análisis (Niveles = Sin participación, Participante solo, Participante con otros)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Página insertada';
$string['invalidfile'] = 'Archivo no válido';
$string['invalidid'] = 'No se superó ningún ID de módulo o de lección en el curso';
$string['invalidlessonid'] = 'La ID de la lección es incorrecta';
$string['invalidoverrideid'] = 'ID de anulación inválido';
$string['invalidpageid'] = 'ID de página no válida';
$string['jump'] = 'Saltar';
$string['jumps'] = 'Saltos';
$string['jumps_help'] = 'Cada respuesta (a una pregunta) o cada  descripción (de una página de contenido) tiene su correspondiente salto. El salto puede ser relativo, como "Esta página" o "Página siguiente", o absoluto, especificando cualquiera de las páginas de la lección.';
$string['jumpsto'] = 'Saltos a <em>{$a}</em>';
$string['leftduringtimed'] = 'Se ha interrumpido una lección con tiempo fijo.<br>Por favor, haga clic en Continuar para volver a empezar la lección.';
$string['leftduringtimednoretake'] = 'Se ha interrumpido una lección con tiempo fijo y<br>no se permite volver a empezar o continuar la lección.';
$string['leftduringtimedsession'] = 'Ha salido de una lección con tiempo programado';
$string['lesson:addinstance'] = 'Añadir una nueva lección';
$string['lesson:edit'] = 'Editar una actividad de lección';
$string['lesson:grade'] = 'Calificar preguntas de tipo ensayo de la lección';
$string['lesson:manage'] = 'Gestionar una actividad de lección';
$string['lesson:manageoverrides'] = 'Administrar excepciones de la lección';
$string['lesson:view'] = 'Ver actividad en la lección';
$string['lesson:viewreports'] = 'Ver informes de lecciones';
$string['lessonclosed'] = 'Esta lección se cerró el {$a}.';
$string['lessoncloses'] = 'La lección se cierra';
$string['lessoncloseson'] = 'La lección se cierra el {$a}';
$string['lessoneventcloses'] = '{$a} cierra';
$string['lessoneventopens'] = '{$a} abre';
$string['lessonformating'] = 'Formato de la Lección';
$string['lessonmenu'] = 'Menú Lección';
$string['lessonname'] = 'Lección: {$a}';
$string['lessonnotready'] = 'Esta lección no está lista para practicar. Por favor, contacte con su {$a}.';
$string['lessonnotready2'] = 'Esta lección no está preparada.';
$string['lessonopen'] = 'Esta lección se abrirá el {$a}.';
$string['lessonopens'] = 'La lección se abre';
$string['lessonpagelinkingbroken'] = 'No se encuentra la primera página. El enlace a la página de la lección debe estar roto. Por favor, contacte con el administrador.';
$string['lessonstats'] = 'Estadísticas de la lección';
$string['linkedmedia'] = 'Medios enlazados';
$string['loginfail'] = 'Acceso fallido, por favor pruebe de nuevo...';
$string['lowscore'] = 'Puntuación baja';
$string['lowtime'] = 'Tiempo bajo';
$string['manualgrading'] = 'Calificar ensayos';
$string['matchesanswer'] = 'Concuerda con la respuesta';
$string['matching'] = 'Emparejamiento';
$string['matchingpair'] = 'Pareja {$a}';
$string['maxgrade'] = 'Calificación máxima';
$string['maxgrade_help'] = 'Este ajuste especifica la calificación máxima de la lección. Si se establece en 0, la lección no aparece en las páginas de notas.';
$string['maximumnumberofanswersbranches'] = 'Número máximo de respuestas';
$string['maximumnumberofanswersbranches_help'] = 'Este ajuste determina el número máximo de respuestas que se pueden usar en la lección. Si solo se utilizan preguntas de tipo Verdadero/Falso, podemos establecer el valor de 2.
Este valor se puede cambiar en cualquier momento ya que sólo afecta a lo que el profesor ve, no a los datos.';
$string['maximumnumberofattempts'] = 'Número máximo de intentos por pregunta';
$string['maximumnumberofattempts_help'] = 'Este ajuste especifica el número máximo de intentos permitidos para cada pregunta. Si se responde incorrectamente en repetidas ocasiones, al alcanzar este valor máximo, se muestra la siguiente página de la lección.';
$string['maximumnumberofattemptsreached'] = 'Se ha alcanzado el número máximo de intentos. Traslado a la página siguiente';
$string['mediaclose'] = 'Mostrar botón de cierre';
$string['mediafile'] = 'Medios enlazados';
$string['mediafile_help'] = 'Se puede cargar un archivo multimedia para utilizarlo en la lección. A continuación, se mostrará un enlace \'Haga clic aquí para ver\' en un bloque denominado \'Medios vinculados\' en cada página de la lección.';
$string['mediafilepopup'] = 'Haga clic aquí para ver';
$string['mediaheight'] = 'Altura de la ventana emergente.';
$string['mediawidth'] = 'Anchura de la ventana emergente.';
$string['messageprovider:graded_essay'] = 'Notificación de ensayo calificado';
$string['minimumnumberofquestions'] = 'Número mínimo de preguntas';
$string['minimumnumberofquestions_help'] = 'Este ajuste determina el número mínimo de preguntas que se utilizarán para calcular una calificación para la actividad.';
$string['missingname'] = 'Por favor, escriba un \'nick\'';
$string['modattempts'] = 'Permitir revisión al estudiante';
$string['modattempts_help'] = '<p>Esta opción permite al estudiante volver atrás para cambiar sus respuestas.</p>';
$string['modattemptsnoteacher'] = 'La revisión del estudiante sólo está disponible para los estudiantes.';
$string['modulename'] = 'Lección';
$string['modulename_help'] = 'La actividad lección permite a un profesor presentar contenidos y/ o actividades prácticas de forma interesante y flexible. Un profesor puede utilizar la lección para crear un conjunto lineal de páginas de contenido o actividades educativas que ofrezcan al alumno varios itinerarios u opciones. En cualquier caso, los profesores pueden optar por incrementar la participación del alumno y asegurar la comprensión mediante la inclusión de diferentes tipos de pregunta, tales como la elección múltiple, respuesta corta y correspondencia. Dependiendo de la respuesta elegida por el estudiante y de cómo el profesor desarrolla la lección, los estudiantes pueden pasar a la página siguiente, volver a una página anterior o dirigirse a un itinerario totalmente diferente.

Una lección puede ser calificada y la calificación registrada en el libro de calificaciones.

Las lecciones pueden ser utilizados

* Para el aprendizaje autodirigido de un nuevo tema
* Para ejercicios basados en escenarios o simulaciones y de  toma de decisiones
* Para realizar ejercicios de repaso diferenciadas, con distintos conjuntos de preguntas de repaso, dependiendo de las respuestas dadas a las preguntas anteriores';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Lecciones';
$string['move'] = 'Mover página';
$string['movedpage'] = 'Página movida';
$string['movepagehere'] = 'Mover la página aquí';
$string['movepagenamed'] = 'Mover página: {$a}';
$string['moving'] = 'Moviendo página: {$a}';
$string['multianswer'] = 'Respuesta múltiple';
$string['multianswer_help'] = '<p>Algunos tipos de pregunta tienen una opción que se activa con un clic en cuadro de verificación.  Los tipos de la pregunta y el significado de las opciones son detallados abajo.

<ol>
<li><p><b>Elección múltiple</b> Es una variante de las preguntas de Opción
Múltiple llamada de <b>&quot;Elección múltiple y respuestas múltiples"</b>.  Si escoge esta opción en la pregunta entonces requieren que el estudiante seleccione todas las respuestas correctas del conjunto de respuestas.  La pregunta puede o no decir al estudiante <i>cuántas</i> respuestas correctas existen. Por ejemplo "¿Cuáles han sido presidentes de
EE.UU.?", o "Seleccione a dos presidentes de EE.UU. de la siguiente lista.".  El número de respuestas correctas pueden ser de <b>una</b> hasta todas las opciones.  (Una pregunta de Elección múltiples y respuestas múltiples con una respuesta correcta <b>es</b> diferente de una pregunta de Opción Múltiple pues la primera permite al estudiante la posibilidad de elegir más de una respuesta mientras que la última no lo permite.)</p></li>

<li><p><b>Respuesta corta</b> Por defecto, en las comparaciones no se tiene en cuenta si el texto está mayúsculas o minúsculas. Si se selecciona Opción de pregunta  las comparaciones tiene en cuenta si el texto está en mayúsculas o minúsculas.</p></li>

<p>En los otros tipos de preguntas no afecta la Opción de pregunta.</p>';
$string['multichoice'] = 'Opción múltiple';
$string['multipleanswer'] = 'Respuesta múltiple';
$string['nameapproved'] = 'Nombre aprobado';
$string['namereject'] = 'Lo sentimos, su nombre ha sido rechazado por el filtro.<br>Por favor, pruebe con otro nombre.';
$string['new'] = 'nueva';
$string['nextpage'] = 'Página siguiente';
$string['noanswer'] = 'Una o más preguntas no se han contestado. Por favor regrese y de una respuesta.';
$string['noattemptrecordsfound'] = 'No se encontraron registros de intentos. Sin calificación';
$string['nobranchtablefound'] = 'No se ha encontrado página de contenido';
$string['noclose'] = 'Sin fecha de cierre';
$string['nocommentyet'] = 'Aún no comentado.';
$string['nocoursemods'] = 'No se encuentran actividades';
$string['nocredit'] = 'No crédito';
$string['nodeadline'] = 'No fecha límite';
$string['noessayquestionsfound'] = 'No se encuentran preguntas de ensayo en esta lección.';
$string['nohighscores'] = 'No puntuaciones más altas';
$string['nolessonattempts'] = 'No se han hecho intentos de practicar esta lección.';
$string['nolessonattemptsgroup'] = '{$a} miembros del grupo no han realizado ningún intento en esta lección.';
$string['none'] = 'Ninguno';
$string['nooneansweredcorrectly'] = 'Nadie ha contestado correctamente.';
$string['nooneansweredthisquestion'] = 'Nadie ha contestado esta pregunta.';
$string['noonecheckedthis'] = 'Nadie eligió esta.';
$string['nooneenteredthis'] = 'Nadie ha introducido esto.';
$string['noonehasanswered'] = 'Nadie ha contestado aún a una pregunta de ensayo.';
$string['noonehasansweredgroup'] = 'Nadie de {$a} ha respondido todavía a ninguna pregunta de tipo ensayo.';
$string['noopen'] = 'Sin fecha de apertura';
$string['nooverridedata'] = 'Deberá anular al menos uno de los ajustes de la lección.';
$string['noretake'] = 'No se le permite retomar esta lección.';
$string['normal'] = 'Normal - seguir el flujo de la lección';
$string['notcompleted'] = 'Sin finalizar';
$string['notcompletedwithdate'] = 'No completado ({$a})';
$string['notdefined'] = 'Sin definir';
$string['notenoughsubquestions'] = 'No se han definido suficientes subpreguntas.<br /> ¿Quiere regresar y arreglar esta pregunta?';
$string['notenoughtimespent'] = 'Ha finalizado esta lección en {$a->timespent}, una cantidad de tiempo inferior al tiempo necesario establecido en {$a->timerequired}. Puede que tenga que volver a realizar un intento en esta lección.';
$string['notgraded'] = 'Sin calificar';
$string['notitle'] = 'Sin título';
$string['notyetcompleted'] = 'La lección se ha comenzado, pero no ha sido finalizada todavía';
$string['numberofcorrectanswers'] = 'Número de respuestas correctas: {$a}';
$string['numberofcorrectanswersheader'] = 'Número de respuestas correctas';
$string['numberofcorrectmatches'] = 'Número de emparejamientos correctos: {$a}';
$string['numberofpagestoshow'] = 'Número de páginas a mostrar';
$string['numberofpagestoshow_help'] = 'Esta ajuste especifica el número de páginas mostradas en la lección. Sólo es aplicable para las lecciones con páginas que se muestran en orden aleatorio (cuando "Acción después de la respuesta correcta" está ajustado a"Mostrar una página no vista"  o "Mostrar unan página no contestada"). Si se establece en cero, se muestran todas las páginas.';
$string['numberofpagesviewed'] = 'Número de páginas vistas: {$a}';
$string['numberofpagesviewedheader'] = 'Número de preguntas respondidas';
$string['numberofpagesviewednotice'] = 'Número de preguntas contestadas: {$a->nquestions} (Debería contestar al menos {$a->minquestions})';
$string['numerical'] = 'Numérica';
$string['numericanswer'] = 'Respuesta numérica';
$string['numericanswer_help'] = 'Puede especificar un número o un rango de números utilizando los dos puntos. Por ejemplo 2:5 significa que cualquier respuesta entre 2 y 5 (ambos incluidos) es correcta.';
$string['offlinedatamessage'] = 'Ha trabajado en este intento utilizando un dispositivo móvil. La información se guardó por última vez en este sitio hace {$a}. Por favor compruebe que no tiene trabajo sin guardar.';
$string['ongoing'] = 'Mostrar puntuación acumulada';
$string['ongoing_help'] = '<p>Cuando se activa esta opción, cada página mostrará los puntos que el estudiante ha obtenido del total de          puntos posible. Por ejemplo, si un estudiante ha contestado correctamente cuatro preguntas de 5 puntos y ha      fallado una pregunta, la puntuación provisional será de 15/20 puntos.</p>';
$string['ongoingcustom'] = 'Ha obtenido {$a->score} punto(s) sobre {$a->currenthigh} hasta ahora.';
$string['ongoingnormal'] = 'Usted ha respondido correctamente {$a->correct} pregunta(s) de un total de {$a->viewed} pregunta(s).';
$string['onpostperpage'] = 'Solo un mensaje por calificación';
$string['openafterclose'] = 'Ha indicado un fecha de apertura posterior a la fecha de cierre';
$string['options'] = 'Opciones';
$string['or'] = 'O';
$string['ordered'] = 'Ordenado';
$string['other'] = 'Otro';
$string['outof'] = 'Fuera de {$a}';
$string['override'] = 'Excepción';
$string['overridedeletegroupsure'] = '¿Está seguro de que desea eliminar la excepción del grupo {$a}?';
$string['overridedeleteusersure'] = '¿Está seguro de que desea eliminar la excepción del usuario {$a}?';
$string['overridegroup'] = 'Excepción de grupo';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Excepciones';
$string['overrideuser'] = 'Excepción de usuario';
$string['overrideusereventname'] = '{$a->lesson} - Excepción';
$string['overview'] = 'Revisión';
$string['overview_help'] = 'Una lección se compone de un conjunto de páginas y, ocasionalmente, de páginas de contenido. Una página contiene información y normalmente termina con una pregunta. Con cada respuesta a la pregunta está asociado un salto. Este puede ser relativo (e.g., a la página actual o a la siguiente) o absoluto (e.g., a cualquiera de las páginas de la lección). Una página de contenido es aquella que contiene un conjunto de enlaces a otras páginas de la lección, e.g., una Tabla de Contenidos.';
$string['page'] = 'Página: {$a}';
$string['page-mod-lesson-edit'] = 'Editar página de la lección';
$string['page-mod-lesson-view'] = 'Ver página de la lección o una vista previa';
$string['page-mod-lesson-x'] = 'Cualquier página de lección';
$string['pageanswers'] = 'Respuestas de la página';
$string['pagecontents'] = 'Contenido de la página';
$string['pageresponses'] = 'Respuestas de la página';
$string['pages'] = 'Páginas';
$string['pagetitle'] = 'Título de la página';
$string['password'] = 'Contraseña';
$string['passwordprotectedlesson'] = '{$a} es una lección protegida con contraseña.';
$string['pleasecheckoneanswer'] = 'Seleccione una respuesta';
$string['pleasecheckoneormoreanswers'] = 'Seleccione una o más respuestas';
$string['pleaseenteryouranswerinthebox'] = 'Por favor escriba su respuesta en la caja';
$string['pleasematchtheabovepairs'] = 'Empareje los siguientes elementos';
$string['pluginadministration'] = 'Administración de la lección';
$string['pluginname'] = 'Lección';
$string['pointsearned'] = 'Puntos ganados';
$string['postprocesserror'] = 'Ha ocurrido un error durante el post-procesamiento';
$string['postsuccess'] = 'Mensaje exitoso';
$string['practice'] = 'Lección de práctica';
$string['practice_help'] = '<p>Las lecciones de práctica no se mostrarán en el libro de calificaciones.</p>';
$string['preprocesserror'] = 'Ha ocurrido un error durante el pre-procesamiento';
$string['prerequisiteisobsolete'] = 'Se eliminará la opción del requisito previo de la lección. En su lugar, utilice las restricciones de acceso.';
$string['prerequisitelesson'] = 'Lección previa requerida';
$string['preview'] = 'Previsualizar';
$string['previewlesson'] = 'Previsualizar {$a}';
$string['previewpagenamed'] = 'Previsualizar página: {$a}';
$string['previouspage'] = 'Página anterior';
$string['privacy:metadata:attempts'] = 'Un registro de intentos de página';
$string['privacy:metadata:attempts:answerid'] = 'El ID de la respuesta';
$string['privacy:metadata:attempts:correct'] = 'Si el intento fue correcto';
$string['privacy:metadata:attempts:pageid'] = 'El ID de la página';
$string['privacy:metadata:attempts:retry'] = 'El número de intento';
$string['privacy:metadata:attempts:timeseen'] = 'El momento en el que se hizo el intento';
$string['privacy:metadata:attempts:useranswer'] = 'Detalles sobre la respuesta del usuario';
$string['privacy:metadata:attempts:userid'] = 'El ID de usuario';
$string['privacy:metadata:branch'] = 'Un registro de las páginas vistas';
$string['privacy:metadata:branch:flag'] = 'Si la siguiente página fue calculada al azar';
$string['privacy:metadata:branch:nextpageid'] = 'El ID de la siguiente página';
$string['privacy:metadata:branch:pageid'] = 'El ID de la página';
$string['privacy:metadata:branch:retry'] = 'El número de intento';
$string['privacy:metadata:branch:timeseen'] = 'El momento en el que la página fue vista';
$string['privacy:metadata:branch:userid'] = 'El ID de usuario';
$string['privacy:metadata:grades'] = 'Un registro de las calificaciones para cada lección';
$string['privacy:metadata:grades:completed'] = 'La fecha en la que la calificación fue otorgada';
$string['privacy:metadata:grades:grade'] = 'La calificación otorgada';
$string['privacy:metadata:grades:userid'] = 'El ID de usuario';
$string['privacy:metadata:overrides'] = 'Un registro de anulaciones por sección';
$string['privacy:metadata:overrides:available'] = 'El momento en el que se puede intentar la lección';
$string['privacy:metadata:overrides:deadline'] = 'La fecha límita para completar la lección.';
$string['privacy:metadata:overrides:maxattempts'] = 'El número máximo de intentos';
$string['privacy:metadata:overrides:password'] = 'La contraseña para acceder a la lección';
$string['privacy:metadata:overrides:retake'] = 'Si están permitidas las repeticiones';
$string['privacy:metadata:overrides:review'] = 'Si se permite intentar de nuevo una pregunta';
$string['privacy:metadata:overrides:timelimit'] = 'Tiempo límite para completar una lección, en segundos.';
$string['privacy:metadata:overrides:userid'] = 'El ID de usuario';
$string['privacy:metadata:timer'] = 'Un registro de un intento de lección';
$string['privacy:metadata:timer:completed'] = 'Si el intento se ha completado';
$string['privacy:metadata:timer:lessontime'] = 'El último momento en el que registramos actividad';
$string['privacy:metadata:timer:starttime'] = 'La fecha en la que comenzó el intento';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'El último momento en el que registramos actividad desde la aplicación móvil';
$string['privacy:metadata:timer:userid'] = 'El ID de usuario';
$string['privacy:metadata:userpref:lessonview'] = 'El modo preferido de visualización cuando se editan lecciones';
$string['privacy:path:essayanswers'] = 'Respuestas de ensayo';
$string['privacy:path:essayresponses'] = 'Respuestas al ensayo';
$string['privacy:path:pages'] = 'Páginas';
$string['processerror'] = 'Ha ocurrido un error durante el procesamiento';
$string['progressbar'] = 'Barra de progreso';
$string['progressbar_help'] = '<p>Muestra una barra de progreso al final de la lección.
Por el momento, la barra de progreso tiene más precisión cuando las lecciones son lineales.</p>
<p>Al calcular el porcentaje completado, las Tablas de ramificación y las páginas de preguntas contestadas correctamente contribuyen al progreso de la lección. Al calcular el número total de páginas de la lección, los conglomerados y las páginas incluídas en los conglomerados sólo cuentan como una página única, excluyéndose las páginas de final de conglomerado y final de tabla de ramificación. El resto de las páginas cuentan para calcular el total de páginas de la lección.</p>
<p>Nota: los estilos por defecto de la barra de progreso no impresionan ;)  Todos los estilos (e.g.: colores, imágenes de fondo, etc.)
de la barra de progreso pueden modificarse en mod/lesson/styles.php.';
$string['progressbarteacherwarning'] = 'La barra de progreso no se muestra para {$a}';
$string['progressbarteacherwarning2'] = 'Usted no verá la barra de progreso porque puede editar esta lección';
$string['progresscompleted'] = 'Ha alcanzado el {$a}% de esta lección';
$string['qtype'] = 'Tipo de página';
$string['question'] = 'Pregunta';
$string['questionoption'] = 'Opción de pregunta';
$string['questiontype'] = 'Tipo de pregunta';
$string['randombranch'] = 'Página de contenido aleatorio';
$string['randompageinbranch'] = 'Pregunta aleatoria dentro de una página de contenido';
$string['rank'] = 'Ranking';
$string['rawgrade'] = 'Calificación en bruto';
$string['receivedcredit'] = 'Crédito recibido';
$string['redisplaypage'] = 'Volver a mostrar página';
$string['removeallgroupoverrides'] = 'Eliminar todas las excepciones de grupo';
$string['removealluseroverrides'] = 'Eliminar todas las excepciones de usuario';
$string['report'] = 'Informe';
$string['reports'] = 'Informes';
$string['response'] = 'Comentario';
$string['retakesallowed'] = 'Se permite volver a tomar la lección';
$string['retakesallowed_help'] = '<p>Esta opción determina si los alumnos pueden tomar una lección más de una vez.
   El profesor puede decidir que la lección contiene material que los alumnos
     deben conocer en profundidad, en cuyo caso se debería permitir que el alumno repita
     la lección. Por otro lado, si el material se utiliza como examen esto no debería
     permitirse.
</p>

<p>Cuando a los alumnos se les permite repetir la lección, la <b>calificación</b> que aparece
    en la página Calificaciones corresponde bien al <B>promedio</B> de calificaciones, bien al <b>mejor</b> resultado obtenido en las repeticiones.
    El siguiente parámetro determina cuál de esas dos alternativas de calificación se utilizará.
</p>
<p>Advierta que el <b>Análisis de Pregunta</b> siempre utiliza las respuestas de los primeros intentos, y que las repeticiones subsiguientes no son tenidas en cuenta.</p>
<p>La opción por defecto es <b>Sí</b>, lo que significa que los alumnos pueden retomar la lección. Se
espera que sólo bajo condiciones excepcionales se seleccione la opción <b>No</b>.
</p>';
$string['returnto'] = '{$a}';
$string['returntocourse'] = 'Volver al curso';
$string['reverttodefaults'] = 'Volver a las opciones predeterminadas de la lección';
$string['review'] = 'Revisión';
$string['reviewlesson'] = 'Revisar lección';
$string['reviewquestionback'] = 'Sí, me gustaría probar de nuevo';
$string['reviewquestioncontinue'] = 'No, deseo pasar a la siguiente';
$string['sanitycheckfailed'] = 'Ha fallado el \'Sanity Check\': Este intento se ha eliminado';
$string['save'] = 'Guardar';
$string['savechanges'] = 'Guardar cambios';
$string['savechangesandeol'] = 'Guardar todos los cambios e ir al final de la lección.';
$string['saveoverrideandstay'] = 'Guardar e introducir otra excepción';
$string['savepage'] = 'Guardar página';
$string['score'] = 'Puntuación';
$string['score_help'] = 'La puntuación solo se utiliza cuando está habilitada la puntuación personalizada. Se puede conceder un valor de puntos numéricos a cada respuesta (positivo o negativo).';
$string['scores'] = 'Puntuaciones';
$string['search:activity'] = 'Lección - información de actividad';
$string['secondpluswrong'] = 'No. ¿Desea probar de nuevo?';
$string['selectallattempts'] = 'Seleccionar todos los intentos';
$string['selectaqtype'] = 'Seleccione un tipo de pregunta';
$string['sent'] = 'Enviado';
$string['shortanswer'] = 'Respuesta corta';
$string['showanunansweredpage'] = 'Mostrar una página no respondida';
$string['showanunseenpage'] = 'Mostrar una página no vista';
$string['singleanswer'] = 'Una sola respuesta';
$string['skip'] = 'Pasar por alto la navegación';
$string['slideshow'] = 'Pase de diapositivas';
$string['slideshow_help'] = '<p>Esta opción permite mostrar la lección como una sesión de diapositivas, con una
anchura, altura y color de fondo personalizado fijos. Se mostrará una barra de
desplazamiento basada en CSS si el contenido de la página excede la anchura o la altura
seleccionadas. Por defecto, las preguntas se "desgajarán" del modo de pase de
diapositivas, y sólo las páginas (i.e., tablas de ramas) se mostrarán en una
diapositiva. Los botones etiquetados por el idioma por defecto como "Siguiente" y
"Anterior" aparecerán en los extremos derecho e izquierdo de la diapositiva si
tal opción es seleccionada en la página. El resto de los botones aparecerán centrados
debajo de la diapositiva.</p>';
$string['slideshowbgcolor'] = 'Color de fondo del pase de diapositivas';
$string['slideshowheight'] = 'Altura del pase de diapositivas';
$string['slideshowwidth'] = 'Anchura del pase de diapositivas';
$string['startlesson'] = 'Comenzar lección';
$string['studentattemptlesson'] = 'Intento número {$a->attempt} de {$a->lastname}, {$a->firstname}';
$string['studentname'] = '{$a} Nombre';
$string['studentoneminwarning'] = 'Atención: Le queda 1 minuto o menos para terminar la lección.';
$string['studentoutoftimeforreview'] = 'Atención: ha agotado el tiempo para revisar esta lección';
$string['studentresponse'] = 'comentario de {$a}';
$string['submit'] = 'Enviar';
$string['submitname'] = 'Enviar nombre';
$string['teacherjumpwarning'] = 'En esta lección se ha utilizado un salto {$a->cluster} o un salto a {$a->unseen}. En su lugar se usará el salto a la  siguiente página. Acceda a su cuenta como estudiante para comprobar estos saltos.';
$string['teacherongoingwarning'] = 'La puntuación acumulada sólo se muestra al estudiante. Acceda  como estudiante para probar la puntuación acumulada.';
$string['teachertimerwarning'] = 'El temporizador sólo funciona para estudiantes. Entre como estudiante para probar el temporizador.';
$string['thatsthecorrectanswer'] = 'Esta es la respuesta correcta';
$string['thatsthewronganswer'] = 'Esta es la respuesta equivocada';
$string['thefollowingpagesjumptothispage'] = 'Las páginas siguientes saltan a esta página';
$string['thispage'] = 'Esta página';
$string['timeisup'] = 'Se ha acabado el tiempo';
$string['timelimit'] = 'Límite de tiempo';
$string['timelimit_help'] = 'Si está habilitado, se muestra una advertencia sobre el límite de tiempo al principio de la lección y un temporizador de cuenta atrás. Las respuestas introducidas después de que se haya agotado el tiempo no se califican.';
$string['timelimitwarning'] = 'Le quedan {$a} para terminar la lección.';
$string['timeremaining'] = 'Tiempo restante';
$string['timespenterror'] = 'Dedicar al menos {$a} minutos a la lección';
$string['timespentminutes'] = 'Tiempo empleado (minutos)';
$string['timetaken'] = 'Tiempo empleado';
$string['totalpagesviewedheader'] = 'Número de páginas vistas';
$string['true'] = 'Verdadero';
$string['truefalse'] = 'Verdadero/falso';
$string['unabledtosavefile'] = 'El archivo que ha subido no se ha podido guardar';
$string['unknownqtypesnotimported'] = 'No se importaron {$a} preguntas con tipos de pregunta no admitidos';
$string['unseenpageinbranch'] = 'Pregunta no vista dentro de una página de conenidos';
$string['unsupportedqtype'] = '¡Tipo de pregunta no admitido ({$a})!';
$string['updatedpage'] = 'Página actualizada';
$string['updatefailed'] = 'Actualización fallida';
$string['updatepagenamed'] = 'Actualizar página: {$a}';
$string['usemaximum'] = 'Utilizar el máximo';
$string['usemean'] = 'Utilizar la media';
$string['usepassword'] = 'Lección protegida con contraseña';
$string['usepassword_help'] = '<p>Si se selecciona esta opción, el estudiante no podrá acceder a la lección a menos que escriba la contraseña.</p>';
$string['useroverrides'] = 'Excepciones de usuario';
$string['useroverridesdeleted'] = 'Excepciones de usuario eliminadas';
$string['usersnone'] = 'Los alumnos no tienen acceso a esta lección';
$string['viewessayanswers'] = 'Ver las respuestas de ensayo';
$string['viewgrades'] = 'Ver calificaciones';
$string['viewreports'] = 'Ver {$a->attempts} intentos {$a->student} completados';
$string['viewreports2'] = 'View {$a} intentos completados';
$string['warning'] = 'Aviso';
$string['welldone'] = '¡Bien hecho!';
$string['whatdofirst'] = '¿Qué desea hacer primero?';
$string['withselectedattempts'] = 'Con los intentos seleccionados...';
$string['wronganswerjump'] = 'Salto a respuesta errónea';
$string['wronganswerscore'] = 'Puntuación de respuesta errónea';
$string['wrongresponse'] = 'Comentario (erróneo)';
$string['xattempts'] = '{$a} intentos';
$string['youhaveseen'] = 'Usted ya ha visto más de una página de esta lección.<br />¿Desea comenzar desde la última página vista?';
$string['youranswer'] = 'Su respuesta';
$string['yourcurrentgradeis'] = 'Su calificación actual es {$a}';
$string['yourcurrentgradeisoutof'] = 'Su calificación actual es {$a->grade} sobre {$a->total}';
$string['youshouldview'] = 'Usted debería ver como mínimo: {$a}';
