<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hsuforum', language 'es', version '3.10'.
 *
 * @package     hsuforum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessible'] = 'Accesible';
$string['activityoverview'] = 'Hay nuevos mensajes en el foro';
$string['addanewdiscussion'] = 'Añadir un nuevo tópico de discusión';
$string['addanewtopic'] = 'Añadir un nuevo hilo';
$string['addareply'] = 'Añadir tu respuesta';
$string['addyourdiscussion'] = 'Añadir tu hilo';
$string['advancedsearch'] = 'Búsqueda avanzada';
$string['ajaxrequesterror'] = 'No se ha podido completar la solicitud, por favor inténtelo de nuevo.';
$string['all'] = 'Todo';
$string['allforums'] = 'Todos los foros';
$string['allowanonymous'] = 'Permitir entradas anónimas';
$string['allowanonymous_help'] = 'Si está activo, el nombre del autor en cada entrada será suprimido cuando se visualice el foro.';
$string['allowdiscussions'] = '¿Puede un {$a} añadir entradas en este foro?';
$string['allowsallsubscribe'] = 'Este foro permite a todos elegir si se suscriben o no';
$string['allowsdiscussions'] = 'Este foro permite a todos los usuarios empezar un tema de discusión.';
$string['allsubscribe'] = 'Suscribirse a todos los foros';
$string['allunsubscribe'] = 'Cancelar la suscripción de todos los foros';
$string['alreadyfirstpost'] = 'Esta ya es la primera entrada en el hilo';
$string['anonymousalternatename'] = 'Anónimo';
$string['anonymousfirstname'] = 'Anónimo';
$string['anonymousfirstnamephonetic'] = 'Anónimo';
$string['anonymouslastname'] = 'Usuario';
$string['anonymouslastnamephonetic'] = 'Usuario';
$string['anonymousrecentactivity'] = 'Podría haber actividad reciente en este foro, pero los detalles no pueden mostrarse porque el foro es anónimo';
$string['anonymouswarning'] = 'Moviendo este hilo podría desvelar información anónima. ¿Está seguro de que quiere hacerlo?';
$string['anyfile'] = 'Cualquier fichero';
$string['areapost'] = 'Mensajes';
$string['articledateformat'] = '%l:%M%P %b %e, %Y';
$string['attachment'] = 'Adjuntos';
$string['attachment_help'] = 'Usted puede anexar opcionalmente uno o más archivos a una publicación en foro. Si Usted anexa una imagen, se mostrará después del  mensaje.';
$string['attachmentnopost'] = 'Usted no puede exportar anexos sin una ID del post';
$string['attachments'] = 'Anexos';
$string['attachments:x'] = 'Anexos: {$a}';
$string['author'] = 'Autor';
$string['blockafter'] = 'Publicar el límite permitido';
$string['blockafter_help'] = 'Esta configuración indica el número máximo de publicaciones que un usuario puede crear en un periodo de tiempo específico. Los usuarios con el permiso mod/hsuforum:postwithoutthrottling no se ven afectados por el límite.';
$string['blockperiod'] = 'Periodo de tiempo del bloqueo.';
$string['blockperiod_help'] = 'Los estudiantes pueden ser bloqueados al publicar más del número de publicaciones definido en un periodo de tiempo específico. Los usuarios con el permiso mod/hsuforum:postwithoutthrottling no se ven afectados por el límite.';
$string['blockperioddisabled'] = 'No bloquear';
$string['blogforum'] = 'Mostrar el foro en formato tipo blog';
$string['bynameondate'] = 'por {$a->name} - {$a->date}';
$string['byx'] = 'por {$a}';
$string['cannnotdeletesinglediscussion'] = 'Lo sentimos, pero ¡ Usted no tiene permitido eliminar esa discusión !';
$string['cannotadd'] = 'No pudo añadirse la discusión a este foro';
$string['cannotadddiscussion'] = 'Añadir discusiones al foro requiere membresía de grupo.';
$string['cannotadddiscussionall'] = 'No tiene permiso de agregar un nuevo tema de discusión para todos los participantes.';
$string['cannotaddsubscriber'] = '¡No se pudo agregar al usuario con id {$a} a este foro!';
$string['cannotaddteacherforumto'] = 'No se pudo agregar la instancia del foro a la sección 0 del curso.';
$string['cannotcreatediscussion'] = 'No se pudo crear la nueva discusión.';
$string['cannotcreateinstanceforteacher'] = 'No se pudo crear la nueva instancia del curso para el foro del profesor';
$string['cannotdeletepost'] = '¡Usted no puede eliminar esta publicación!';
$string['cannoteditposts'] = '¡No puede editar las publicaciones de otras personas!';
$string['cannotfinddiscussion'] = 'No se pudo encontrar la discusión en este foro';
$string['cannotfindfirstpost'] = 'No se pudo encontrar la primera publicación en este foro';
$string['cannotfindorcreateforum'] = 'No se pudo encontrar o crear el foro principal de novedades para el sitio';
$string['cannotfindparentpost'] = 'No se pudo encontrar el antecesor de la publicación {$a}';
$string['cannotmakeprivatereplies'] = 'Lo sentimos, pero no tiene permitido realizar respuestas privadas en este foro';
$string['cannotmovefromsingleforum'] = 'No puede mover la discusión de un foro de discusión de tema único';
$string['cannotmovenotvisible'] = 'Foro no visible';
$string['cannotmovetonotexist'] = '¡No puede mover a ese foro - no existe!';
$string['cannotmovetonotfound'] = 'El foro destino no se encuentra en este curso.';
$string['cannotmovetosingleforum'] = 'No puede mover la discusión a un foro de discusión de tema único';
$string['cannotpurgecachedrss'] = 'No se pudo limpiar la caché de noticias RSS para los foros  fuente/destino - revise su archivo de permisos del foro';
$string['cannotremovesubscriber'] = '¡No puede cancelar la suscripción del usuario {$a} de este foro!';
$string['cannotreply'] = 'Usted no puede contestar a esta publicación';
$string['cannotsplit'] = 'Las discusiones de este foro no pueden ser divididas';
$string['cannotsubscribe'] = 'Lo sentimos, pero debe pertenecer a un grupo de miembros para suscribirse.';
$string['cannottrack'] = 'No se pudo dejar de seguir ese foro';
$string['cannotunsubscribe'] = 'No se pudo cancelar su suscripción a ese foro';
$string['cannotupdatepost'] = 'Usted no puede actualizar esta publicación';
$string['cannotviewpostyet'] = 'Usted aún no puede leer las preguntas de otros estudiantes en la discusión porque Usted todavía no ha publicado';
$string['cannotviewusersposts'] = 'No hay publicaciones hechas por este usuario que usted pueda ver.';
$string['cansubscribediscerror'] = 'No tiene permitido suscribirse a esta discusión';
$string['cleanreadtime'] = 'Marcar publicaciones antiguas como leidas';
$string['clicktocollapse'] = 'Haga clic para ocultar el mensaje publicado y cualquier respuesta';
$string['clicktoexpand'] = 'Haga clic para ver el mensaje publicado y cualquier respuesta';
$string['collapseall'] = 'Colapsarlo todo';
$string['completiondiscussions'] = 'El estudiante debe crear las discusiones:';
$string['completiondiscussionsdesc'] = 'El estudiante debe crear al menos {$a} discusión(es)';
$string['completiondiscussionsgroup'] = 'Necesita discusiones';
$string['completiondiscussionshelp'] = 'se requieren discusiones para completar';
$string['completionposts'] = 'El estudiante debe publicar discusiones o respuestas';
$string['completionpostsdesc'] = 'El estudiante debe publicar al menos {$a} discusión(es) o respuestas';
$string['completionpostsgroup'] = 'Requiere publicaciones';
$string['completionpostshelp'] = 'se requieren discusiones o respuestas para completar';
$string['completionreplies'] = 'El estudiante debe publicar respuestas:';
$string['completionrepliesdesc'] = 'El estudiante debe publicar al menos {$a} respuestas';
$string['completionrepliesgroup'] = 'Requerir respuestas';
$string['completionreplieshelp'] = 'se requieren respuestas para completar';
$string['completionusegradeerror'] = 'No necesita calificación porque este foro no es calificado. Usted puede quitar el requisito de finalización o Usted puede hacer este foro calificado.';
$string['configcleanreadtime'] = 'Hora del día para limpiar las publicaciones antiguas de la tabla de \'lectura\'.';
$string['configdigestmailtime'] = 'Quien haya elegido recibir notificaciones por correo en el formulario de resumen de correo, recibirá el resumen diario. Este ajuste controla a qué hora del día se enviarán los correos (el siguiente cron que se ejecute después de esta hora los enviará)';
$string['configenablerssfeeds'] = 'Este indicador habilita la posibilidad de canales de noticias RSS para todos los foros. También sera necesario habilitar esta configuracion manualmente en cada foro.';
$string['configenabletimedposts'] = 'Seleccione "Si" si quiere permitir la visualización de periodos de tiempo al publicar en un nuevo foro de discusión.';
$string['confighiderecentposts'] = 'Seleccione "si" para dejar de mostrar las publicacione recientes en la página del curso.';
$string['configlongpost'] = 'Cualquier publicación mayor a este tamaño (en caracteres, no incluyendo HTML) es considerada grande. Las publicaciones mostradas en: la página inical del sitio, páginas sociales del curso, ó perfiles de usuario, se muestran más cortas en un tamaño entre los valores de hsuforum_shortpost y hsuforum_longpost.';
$string['configmanydiscussions'] = 'El número máximo de discusiones visibles en un foro por pagina';
$string['configmaxattachments'] = 'Número máximo de anexos permitidos por publicación.';
$string['configmaxbytes'] = 'Tamaño máximo para los anexos en los foros del sitio (restringido por los límites del curso y otras configuraciones locales)';
$string['configoldpostdays'] = 'Número de días de antiguedad para considerar un post como leído.';
$string['configreplytouser'] = 'Cuando una publicación del foro es enviada por correo, ¿debería contener la direccion del usuario para que se puedan contactar personalmente en lugar de hacerlo a través del foro? Incluso si elige esta opción, los usuarios pueden elegir  mantener su dirección de correo privada.';
$string['configshortpost'] = 'Cualquier publicación menor a este tamaño (en caracteres sin incluir HTML) es considerada pequeña (ver abajo).';
$string['configsubscriptiontype'] = 'Configuraciones por defecto para el modo de suscripción.';
$string['configusermarksread'] = 'Si elige "si", el usuario debe marcar manualmente las publicaciones leídas. Si elige "no", al ver una publicación se marca como leída.';
$string['confirmsubscribe'] = '¿Está seguro de querer suscribirse al foro "{$a}"?';
$string['confirmunsubscribe'] = '¿Esta seguro de querer dejar de seguir el foro "{$a}"?';
$string['couldnotadd'] = 'No se pudo agregar su publicación debido a un error desconocido.';
$string['couldnotdeletereplies'] = 'Lo sentimos, no se puede borrar ya que ha recibido  respuestas';
$string['couldnotupdate'] = 'No se pudo actualizar su publicación debido a un error desconocido';
$string['createdbynameondate'] = 'Creado por {$a->name} en {$a->date}';
$string['crontask'] = 'Trabajos de envío de correo electrónico y mantenimiento';
$string['csv'] = 'CSV';
$string['date'] = 'Fecha';
$string['default'] = 'Por defecto';
$string['delete'] = 'Borrar';
$string['deleteattachments'] = 'Borrar anexos';
$string['deleteattachmentx'] = 'Borrar {$a}';
$string['deleteddiscussion'] = 'El tema de discusión ha sido eliminado';
$string['deletedpost'] = 'La publicación ha sido eliminada';
$string['deletedposts'] = 'Esas publicaciones han sido eliminadas';
$string['deletesure'] = '¿Está seguro de querer eliminar esta publicación?';
$string['deletesureplural'] = '¿Está seguro de querer eliminar esta publicación y todas sus respuestas? ({$a} publicaciones)';
$string['digestmailheader'] = 'Este es su resumen de correo diario de nuevos mensajes en los foros de {$a->sitename}. Para cambiar sus preferencias de correos de foro, vaya a {$a->userprefs}.';
$string['digestmailpost'] = 'Cambie sus preferencias de resumen de correo de foros';
$string['digestmailpostlink'] = 'Cambiar sus preferencias del resumen del foro: {$a}';
$string['digestmailprefs'] = 'su perfil de usuario';
$string['digestmailsubject'] = '{$a}: Resumen de correo de foros';
$string['digestmailtime'] = 'Hora de envío de resúmenes de correo';
$string['digestsentusers'] = 'Resumen de correo enviado con éxito a  {$a} usuarios.';
$string['disallowsubscribe'] = 'Suscripciones no permitidas';
$string['disallowsubscribeteacher'] = 'Suscripciones no permitidas (exceptuando a profesores)';
$string['discussion'] = 'Discusión';
$string['discussion:x'] = 'Discusión: {$a}';
$string['discussiondisplay'] = 'Mostrar discusión';
$string['discussionlocked'] = 'Esta discusión ha sido bloqueada, por lo que Usted ya no puede responder a ella.';
$string['discussionlockingdisabled'] = 'No bloquear discusiones';
$string['discussionlockingheader'] = 'Bloqueo de discusiones';
$string['discussionmoved'] = 'Esta discusión ha sido movida a "{$a}"';
$string['discussionmovedpost'] = 'Esta discusión ha sido movida a <a href="{$a->discusshref}">aquí</a> en el foro <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Nombre de la discusión';
$string['discussions'] = 'Discusiones';
$string['discussionsortkey:created'] = 'Fecha de creación';
$string['discussionsortkey:lastreply'] = 'Reciente';
$string['discussionsortkey:replies'] = 'Más activo';
$string['discussionsortkey:subscribe'] = 'Suscrito';
$string['discussionsplit'] = 'La discusión ha sido dividida';
$string['discussionsstartedby'] = 'Discusiones iniciadas por {$a}';
$string['discussionsstartedbyrecent'] = 'Discusiones recientemente iniciadas por {$a}';
$string['discussionsstartedbyuserincourse'] = 'Discusiones iniciadas por {$a->fullname} en {a->coursename}';
$string['discussionsubscribers'] = 'Seguidores de la discusión';
$string['discussthistopic'] = 'Discutir este asunto';
$string['displaydiscussionreplies'] = 'Mostrar respuestas a discusión';
$string['displayend'] = 'Fin de la discusión';
$string['displayend_help'] = 'Esta configuración especifica si es que una publicación en foro debería de ocultarse después de una cierta fecha. Tenga en cuenta que los administradores siempre podrán ver las publicaciones en foros.';
$string['displayperiod'] = 'Período a mostrar';
$string['displaystart'] = 'Inicio de mostrado';
$string['displaywordcount'] = 'Mostrar conteo de palabras';
$string['displaywordcount_help'] = 'Esta configuración especifica si es que debe o no mostrarse el número de palabras de cada publicación.';
$string['eachuserforum'] = 'Cada persona publica una discusión';
$string['edit'] = 'Editar';
$string['editedby'] = 'Editado por {$a->name} - envío original {$a->date}';
$string['editedpostupdated'] = 'La publicación de {$a} fue actualizada';
$string['editing'] = 'Editando';
$string['editingpost'] = 'Editando publicación';
$string['emaildigestcompleteshort'] = 'Publicaciones completas';
$string['emaildigestdefault'] = 'Por defecto ({$a})';
$string['emaildigestoffshort'] = 'Sin resumen';
$string['emaildigestsubjectsshort'] = 'Solamente asuntos';
$string['emaildigesttype'] = 'Opciones de resumen de correo';
$string['emaildigesttype_help'] = 'Tipo de notificación que recibirá de cada foro:

* Por defecto - Sigue los ajustes de resumen de correo de su perfil de usuario. Si actualiza su perfil, los cambios se verán reflejados también aquí;
* Sin resumen - Recibirá un correo por cada mensaje del foro;
* Resumen - mensajes completos- Recibirá un resumen de correo diario con el contenido completo de cada mensaje del foro;
* Resumen - sólo asunto- Recibirá un resumen de correo diario sólo con el asunto de cada mensaje del foro.';
$string['erroremptymessage'] = 'El mensaje a publicar no puede estar vacío';
$string['erroremptysubject'] = 'El asunto del mensaje a publicar no puede estar vacío';
$string['errorenrolmentrequired'] = 'Usted necesita estar inscrito en este curso para acceder a este contenido';
$string['errortimestartgreater'] = 'La hora de inicio no puede ser después de la hora de fin.';
$string['errorwhiledelete'] = 'Ocurrió un error al eliminar registro.';
$string['eventcoursesearched'] = 'Curso buscado';
$string['eventdiscussioncreated'] = 'Discusión creada';
$string['eventdiscussiondeleted'] = 'Discusión eliminada';
$string['eventdiscussionmoved'] = 'Discusión movida';
$string['eventdiscussionupdated'] = 'Discusión actualizada';
$string['eventdiscussionviewed'] = 'Discusión vista';
$string['eventpostcreated'] = 'Publicación creada';
$string['eventpostdeleted'] = 'Publicación eliminada';
$string['eventpostupdated'] = 'Publicación actualizada';
$string['eventreadtrackingdisabled'] = 'Monitoreo de lectura deshabilitado';
$string['eventreadtrackingenabled'] = 'Monitoreo de lectura habilitado';
$string['eventsubscribersviewed'] = 'Suscriptores vistos';
$string['eventsubscriptioncreated'] = 'Suscripción creada';
$string['eventsubscriptiondeleted'] = 'Suscripción eliminada';
$string['eventuserreportviewed'] = 'Informe de usuario visto';
$string['everyonecanchoose'] = 'Todos pueden elegir estar suscritos';
$string['everyonecannowchoose'] = 'Ahora todos pueden elegir estar suscritos';
$string['everyoneisnowsubscribed'] = 'Ahora todos están  suscritos a este foro';
$string['everyoneissubscribed'] = 'Todos están suscritos a este foro';
$string['existingsubscribers'] = 'Suscriptores existentes';
$string['expandall'] = 'Expandir todo';
$string['export'] = 'Exportar';
$string['exportattachments'] = 'Exportar anexos';
$string['exportdiscussion'] = 'Exportar discusión completa a portafolios';
$string['exportformat'] = 'Formato de exportación';
$string['forcessubscribe'] = 'Este foro forza a todos a estar sucritos';
$string['forum'] = 'Foro';
$string['forumauthorhidden'] = 'Autor (oculto)';
$string['forumblockingalmosttoomanyposts'] = 'Usted se está acercando al umbral de publicaciones. Usted ha publicado {$a->numposts} veces en los últimos {$a->blockperiod} y el límite es de {$a->blockafter} publicaciones.';
$string['forumbodydeleted'] = 'El contenido de este foro ha sido eliminado y ya no puede ser accesado.';
$string['forumbodyhidden'] = 'Esta publicación no puede ser vista por usted, probablemente porque usted no ha publicado en la discusión, el tiempo máximo para editar todavía no ha pasado, la discusión no ha iniciado o la discusión ha expirado.';
$string['forumintro'] = 'Descripción';
$string['forumname'] = 'Nombre del foro';
$string['forumposts'] = 'Publicaciones en foro';
$string['forums'] = 'Foros';
$string['forumsubjectdeleted'] = 'Esta publicación del foro ha sido eliminada';
$string['forumsubjecthidden'] = 'Asunto (oculto)';
$string['forumtracked'] = 'Las publicaciones no leídas están siendo monitoreadas';
$string['forumtrackednot'] = 'Las publicaciones no leídas NO están siendo monitoreadas';
$string['forumtype'] = 'Tipo de foro';
$string['general'] = 'General';
$string['generalforum'] = 'Foro estandar para uso general';
$string['generalforums'] = 'Foros generales';
$string['grade'] = 'Calificación';
$string['gradeitem:posts'] = 'Publicaciones';
$string['gradetype'] = 'Tipo de calificación';
$string['gradetypemanual'] = 'Manual';
$string['gradetypenone'] = 'Ninguno/a';
$string['gradetyperating'] = 'Valoración';
$string['gradingmethodpreview'] = 'Criterio para calificar';
$string['hiddenforumpost'] = 'Publicación oculta de foro';
$string['hiderecentposts'] = 'Ocultar Publicaciones recientes';
$string['hsuforum:addinstance'] = 'Añadir un nuevo foro';
$string['hsuforum:addnews'] = 'Añadir anuncios';
$string['hsuforum:addquestion'] = 'Añadir pregunta';
$string['hsuforum:allowforcesubscribe'] = 'Permitir forzar suscripción';
$string['hsuforum:allowprivate'] = 'Permitirle al usuario responder privadamente';
$string['hsuforum:canoverridediscussionlock'] = 'Contestar a discusiones bloqueadas';
$string['hsuforum:canposttomygroups'] = 'Puede publicar a todos los grupos a los que usted tenga acceso';
$string['hsuforum:createattachment'] = 'Crear anexos';
$string['hsuforum:deleteanypost'] = 'Eliminar cualquier publicación (en cualquier momento)';
$string['hsuforum:deleteownpost'] = 'eliminar publicaciones propias (dentro del tiempo límite)';
$string['hsuforum:editanypost'] = 'Editar cualquier publicación';
$string['hsuforum:exportdiscussion'] = 'Exportar la discusión completa';
$string['hsuforum:exportownpost'] = 'Exportar la publicación propia';
$string['hsuforum:exportpost'] = 'Exportar publicación';
$string['hsuforum:managesubscriptions'] = 'Gestionar suscriptores';
$string['hsuforum:movediscussions'] = 'Mover discusiones';
$string['hsuforum:postwithoutthrottling'] = 'Eximir del umbral del foro';
$string['hsuforum:rate'] = 'Valorar publicaciones';
$string['hsuforum:replynews'] = 'Responder a anuncios';
$string['hsuforum:replypost'] = 'Contestar a las publicaciones';
$string['hsuforum:revealpost'] = 'Revelarse Usted mismo en un foro anónimo';
$string['hsuforum:splitdiscussions'] = 'Dividir discusiones';
$string['hsuforum:startdiscussion'] = 'Iniciar nuevas discusiones';
$string['hsuforum:viewallratings'] = 'Ver todas las valoraciones crudas dadas por individuoes';
$string['hsuforum:viewanyrating'] = 'Ver valkoraciones totales que todos recibieron';
$string['hsuforum:viewdiscussion'] = 'Ver discusiones';
$string['hsuforum:viewhiddentimedposts'] = 'Ver publicaciones ocultas por tiempo';
$string['hsuforum:viewqandawithoutposting'] = 'Siempre ver publicacioens de Preguntas y Respuestas';
$string['hsuforum:viewrating'] = 'Ver la valoración total que Usted recibió';
$string['hsuforum:viewsubscribers'] = 'ver suscrioptores';
$string['indicator:cognitivedepth'] = 'Foro cognitivo';
$string['indicator:cognitivedepth_help'] = 'Este indicador está basado en la profundidad cognitiva alcanzada por el estudiante en una actividad de Foro.';
$string['indicator:socialbreadth'] = 'Foro social';
$string['indicator:socialbreadth_help'] = 'Este indicador está basado en la amplitud social alcanzada por el estudiante en una actividad de Foro.';
$string['inforum'] = 'en {$a}';
$string['inprivatereplyto'] = 'en respuesta privada a';
$string['inreplyto'] = 'en respuesta a';
$string['intronews'] = 'Noticias y avisos generales';
$string['introsocial'] = 'Un foro abierto para chatear sobre cualquier tema que desee';
$string['introteacher'] = 'Un for solamente para notas y discusión del profesor';
$string['invalidaccess'] = 'Esta página no fue accesada correctamente';
$string['invaliddigestsetting'] = 'Se ha proporcionado un ajuste de resumen de correo no válido';
$string['invaliddiscussionid'] = 'La ID de la discusión era incorrecta o ya no existe';
$string['invalidforcesubscribe'] = 'Modo de forzar suscripción a foro inválido';
$string['invalidforumid'] = 'ID del foro era incorrecta';
$string['invalidparentpostid'] = 'ID de publicación paterna era incorrecta';
$string['invalidpostid'] = 'ID de publicación inválida - {$a}';
$string['javascriptdisableddisplayformat'] = 'JavaScript ha sido  deshabilitado en su navegador. Por favor, habilite JavaScript y vuelva a cargar la página o seleccione una visualización de discusión diferente.';
$string['jsondecodeerror'] = 'No se pudo descodificar respuesta; por favor inténtelo nuevamente.';
$string['lastpostbyx'] = 'Última publicación por {$a->name} en {$a->time}';
$string['lastposttimeago'] = 'Último/a {$a}';
$string['learningforums'] = 'Foros de aprendizaje';
$string['loadmorediscussions'] = 'Cargar más discusiones';
$string['lockdiscussionafter'] = 'Bloquear discusiones después de período de inactividad';
$string['longpost'] = 'Publicación larga';
$string['mailnow'] = 'Enviar notificaciones sin retraso de tiempo de edición';
$string['manageforumsubscriptions'] = 'Gestionar suscripciones del foro';
$string['managesubscriptionsoff'] = 'Terminar de gestionar suscripciones';
$string['managesubscriptionson'] = 'Gestionar suscriptores';
$string['manydiscussions'] = 'Discusiones por página';
$string['markalldread'] = 'Marcar todas las publicaciones en esta discusión como leídas.';
$string['markallread'] = 'Marcar todas las publicaciones en este foro como leídas.';
$string['markasreadonnotificationno'] = 'No marcar esta publicación como leída';
$string['markasreadonnotificationyes'] = 'Marcar la publicación como leída';
$string['markread'] = 'Maracr como leído';
$string['markreadbutton'] = 'Marcar como <br />leído';
$string['markunread'] = 'Marcar como no-leído';
$string['markunreadbutton'] = 'Marcar como <br />no-leído';
$string['maxattachments'] = 'Número máximo de anexos';
$string['maxattachmentsize'] = 'Tamño máximo del anexo';
$string['maxattachmentsize_help'] = 'Esta configuración especifica el tamaño máximo del archivo que puede ser anexado a una publicación del foro.';
$string['maxtimehaspassed'] = '¡Lo siento, pero el tiempo máximo para editar esta publicación ({$a}) ha pasado!';
$string['message'] = 'Mensaje';
$string['messageisrequired'] = 'Se requiere el mensaje';
$string['messageplaceholder'] = 'Escriba su publicación';
$string['messageprovider:digests'] = 'Suscripciones avanzadas a resúmens de foros';
$string['messageprovider:posts'] = 'Suscrito a publicaciones de Open forum';
$string['modeflatfirstname'] = 'Mostrar respuestas planas, por nombre de usuario';
$string['modeflatlastname'] = 'Mostrar respuestas planas, por apellido de usuario';
$string['modeflatnewestfirst'] = 'Mostrar respuestas planas, con las más nuevas primero';
$string['modeflatoldestfirst'] = 'Mostrar respuestas en forma plana, las más antiguas primero';
$string['modenested'] = 'Mostrar respuestas en forma anidada';
$string['modethreaded'] = 'Mostrar respuestas en forma de hilo';
$string['modulename'] = 'Open Forum (Foro Abierto)';
$string['modulename_link'] = 'mod/hsuforum/view';
$string['modulenameplural'] = 'Open Forums (Foros Abiertos)';
$string['more'] = 'más';
$string['movedmarker'] = '(Movido)';
$string['movethisdiscussionto'] = 'Mover esta discusión a ...';
$string['myprofileotherdis'] = 'Discusiones de Open Forum';
$string['myprofileotherpost'] = 'Publicaciones de Open Forum';
$string['myprofileowndis'] = 'Mis discusiones de Open Forum';
$string['myprofileownpost'] = 'Mis publicaciones de Open Forum';
$string['namenews'] = 'Anuncios';
$string['namenews_help'] = 'El foro de Anuncios del curso es un foro especial para anuncios y es creado automáticamente cuando se crea un curso. Un curso solamente puede tener un solo foro de Novedades. Solamente los profesores y administradores pueden publicar en el foro de Novedades. El bloque de ""Últimas noticias" mostrará anuncios recientes.';
$string['namesocial'] = 'Foro social';
$string['nested'] = 'Anidado';
$string['newforumposts'] = 'Publicaciones recientes del foro';
$string['nextdiscussion'] = 'Discusiones más nuevas';
$string['nextdiscussionx'] = '({$a}) Siguiente>';
$string['noattachments'] = 'No hay anexos a esta publicación';
$string['nodiscussionsstartedby'] = '{$a} no ha iniciado ninguna discusión';
$string['nodiscussionsstartedbyyou'] = 'Usted aun no ha iniciado ninguna discusión';
$string['noguestpost'] = 'Lo sentimos; los invitados no tienen permitido publicar.';
$string['noguesttracking'] = 'Lo sentimos; los invitados no tienen permitido configurar opciones de monitoreo.';
$string['nomorepostscontaining'] = 'No se encontraron más publicaciones que contengan \'{$a}\'';
$string['nonanonymous'] = 'No anónimamente';
$string['nonews'] = 'Aun no se han publicado anuncios.';
$string['noonecansubscribenow'] = 'Ahora las suscripciones están deshabilitadas';
$string['nopermissiontosubscribe'] = 'Usted no tiene permiso para ver suscriptores del foro';
$string['nopermissiontoview'] = 'Usted no tiene permiso para ver esta publicación';
$string['nopostforum'] = 'Lo sentimos; usted no tiene permiso para publicar a este foro';
$string['noposts'] = 'Sin publicaciones';
$string['nopostsmadebyuser'] = '{$a} no ha hecho ninguna  publicación';
$string['nopostsmadebyyou'] = 'Usted no ha hecho ninguna  publicación';
$string['nosubscribers'] = 'Aun no hay suscriptores para este foro';
$string['notexists'] = 'Ya no existe la discusión';
$string['nothingnew'] = 'Nada nuevo para {$a}';
$string['notingroup'] = 'Lo sentimos, pero usted necesita ser parte de un grupo para ver este foro.';
$string['notinstalled'] = 'El módulo de foro no está instalado';
$string['notpartofdiscussion'] = 'Esta publicación no es parte de una discusión';
$string['notrackforum'] = 'No monitorear publicaciones no leídas';
$string['notuploadedfile'] = 'Hubo un problema al subir su archivo; por favor inténtelo nuevamente';
$string['noviewdiscussionspermission'] = 'Usted no tiene permiso para ver discusiones en este foro';
$string['nowallsubscribed'] = 'Ahora usted está suscrito a todos los foros en {$a}.';
$string['nowallunsubscribed'] = 'Ahora usted está des-suscrito de todos los foros en {$a}.';
$string['nownotsubscribed'] = '{$a->name} NO será notificado acerca de nuevas publicaciones en \'{$a->forum}\'';
$string['nownottracking'] = '{$a->name} ya no está monitoreando \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} será notificado acerca de nuevas publicaciones en \'{$a->forum}\'';
$string['nowtracking'] = '{$a->name} ahora está monitoreando \'{$a->forum}\'.';
$string['numposts'] = '{$a} publicaciones';
$string['olderdiscussions'] = 'Discusiones más antiguas';
$string['oldertopics'] = 'Asuntos más antiguos';
$string['oldpostdays'] = 'Leer después de días';
$string['onediscussion'] = '1 discusión';
$string['onereply'] = '1 respuesta';
$string['openmode0'] = 'Sin discusiones, sin respuestas';
$string['openmode1'] = 'Sin discusiones, pero las respuestas están permitidad';
$string['openmode2'] = 'Las discusiones y respuestas están permitidas';
$string['options'] = 'Opciones';
$string['orderdiscussionsby'] = 'Ordenar por';
$string['overviewnumpostssince'] = '{$a} publicaciones desde el último ingreso';
$string['overviewnumunread'] = '{$a} total sin leer';
$string['page-mod-hsuforum-view'] = 'Página principal de módulo Foro';
$string['page-mod-hsuforum-x'] = 'Cualquier página de módulo Foro';
$string['parent'] = 'Mostrar padre';
$string['parentofthispost'] = 'Padre de esta publicación';
$string['participants'] = 'Participantes';
$string['plaintext'] = 'Texto simple';
$string['pluginadministration'] = 'Adm,inistración del foro';
$string['pluginname'] = 'Open Forum (Foro Abierto)';
$string['postaddedsuccess'] = 'Su publicación fue añadida exitosamente';
$string['postaddedtimeleft'] = 'Usted tiene {$a} para editar por si quisiera hacer algún cambio.';
$string['postbyuser'] = '{$a->post} por {$a->user}';
$string['postbyx'] = 'Publicación por {$a}';
$string['postbyxinprivatereplytox'] = 'Contestación privada a {$a->parent} de parte de {$a->author}';
$string['postcreated'] = 'Publicación creada';
$string['postdeleted'] = 'Publicación eliminada';
$string['postincontext'] = 'Ver esta publicación en contexto';
$string['postoptions'] = 'Publicar opiniones';
$string['postrating1'] = 'Principalmente conocimiento separado';
$string['postrating2'] = 'Separado y conectado';
$string['postrating3'] = 'Principalmente conocimiento conectado';
$string['posts'] = 'Publicaciones';
$string['postsfor'] = 'Publicaciones para';
$string['postsmadebyuser'] = 'Publicaciones hechas por {$a}';
$string['postsmadebyuserincourse'] = 'Publicaciones hechas por {$a->fullname} en {$a->coursename}';
$string['posttoforum'] = 'Publicar al foro';
$string['posttomygroups'] = 'Publicar una copia a todos los grupos';
$string['postwasupdated'] = 'La publicación fue actualizada';
$string['potentialsubscribers'] = 'Suscriptores potenciales';
$string['prevdiscussionx'] = '< Anterior ({$a})';
$string['previousdiscussion'] = 'Discusión más antigua';
$string['print'] = 'Imprimir';
$string['privacy:metadata:hsuforum_digests:maildigest'] = 'La preferencia del resumen';
$string['privacy:metadata:hsuforum_read:postid'] = 'La publicación que fue leída.';
$string['privatereplies'] = 'Permitir respuestas privadas';
$string['privatereply'] = 'Respuesta privada';
$string['privatereplybyx'] = 'Respuesta privada por {$a}';
$string['processingdigest'] = 'Procesando resumen de correo para el usuario {$a}';
$string['prune'] = 'Dividir';
$string['replies'] = 'Contestaciones';
$string['repliesmany'] = '{$a} contestaciones hasta ahora';
$string['repliesone'] = '{$a} contestación hasta ahora';
$string['repliesx'] = 'Contestaciones: {$a}';
$string['resetdigests'] = 'Borrar todas las preferencias de resumen de correo de usuarios';
$string['search'] = 'Buscar';
$string['searchforums'] = 'Buscar';
$string['searchresults'] = 'Resultados de la búsqueda';
$string['startedby'] = 'Iniciado por';
$string['startedbyx'] = 'Iniciado por {$a}';
$string['subject'] = 'Asunto';
$string['subjectisrequired'] = 'Se necesita Asunto';
$string['subjectplaceholder'] = 'Su asunto';
$string['submit'] = 'Enviar';
$string['subscribe'] = 'Suscribirse a este foro';
$string['subscribed'] = 'Suscrito';
$string['subscribedisc'] = 'Suscribirse a esta discusión';
$string['subscribers'] = 'Suscriptores';
$string['subscription'] = 'Suscripción';
$string['subscriptionauto'] = 'Auto suscripción';
$string['subscriptiondisabled'] = 'Suscripción deshabilitada';
$string['subscriptionforced'] = 'Suscripción forzosa';
$string['subscriptionmode'] = 'Modo de suscripción';
$string['subscriptionoptional'] = 'Suscripción opcional';
$string['subscriptions'] = 'Suscripciones';
$string['thisisanonymous'] = 'Este foro es anónimo';
$string['toggled:subscribe'] = 'Suscrito';
$string['totalrating'] = 'Valoración: {$a}';
$string['trackingoptions'] = 'Opciones de monitoreo';
$string['tree'] = 'Árbol';
$string['unread'] = 'Nuevo';
$string['unreadposts'] = 'Publicaciones sin leer';
$string['unreadpostsnumber'] = '{$a} publicaciones sin leer';
$string['unreadpostsone'] = '1 publicación sin leer';
$string['unreadx'] = 'Sin leer: {$a}';
$string['unsubscribed'] = 'Des-suscrito';
$string['unsubscribeshort'] = 'Des-suscribir';
$string['useadvancededitor'] = 'Usar editor avanzado y opciones adicionales';
$string['viewalldiscussions'] = 'Ver todas las discusiones';
$string['xdiscussions'] = '{$a} discusiones';
$string['xreplies'] = '{$a} respuestas';
$string['xunread'] = '{$a} nuevos';
$string['yournewquestion'] = 'Su nueva pregunta';
$string['yournewtopic'] = 'Su nuevo tópico de discusión';
$string['yourreply'] = 'Su respuesta';
