<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'es', version '3.10'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Tienes próximas sesiones de BigBlueButton';
$string['bbbduetimeoverstartingtime'] = 'La hora de vencimiento para esta actividad debe ser mayor que la hora de inicio';
$string['bbbdurationwarning'] = 'La duración máxima para esta sesión es de %duration% minutos.';
$string['bbbrecordallfromstartwarning'] = 'Esta sesión se está grabando desde el principio.';
$string['bbbrecordwarning'] = 'Esta sesión puede ser grabada.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Añadir una nueva sala/actividad de bigbluebuttonbn';
$string['bigbluebuttonbn:join'] = 'Unirse a una reunión de bigbluebuttonbn';
$string['bigbluebuttonbn:managerecordings'] = 'Gestionar las grabaciones de bigbluebuttonbn';
$string['bigbluebuttonbn:meeting'] = 'Crear instancias con capacidad de reuniones en vivo';
$string['bigbluebuttonbn:recording'] = 'Crear instancias con capacidad de grabación';
$string['bigbluebuttonbn:view'] = 'Ver una sala/actividad';
$string['calendarstarts'] = '{$a} está programado para';
$string['completionattendance'] = 'El estudiante debe asistir a la reunión para:';
$string['completionattendancedesc'] = 'El estudiante debe asistir a la reunión y permanecer en la sesión durante al menos {$a} minuto(s)';
$string['completionattendancegroup'] = 'Requerir asistencia';
$string['completionattendancegroup_help'] = 'Se requiere la asistencia a la reunión durante (n) minutos para completar';
$string['completionengagementchats'] = 'Eventos del chat';
$string['completionengagementdesc'] = 'El estudiante debe participar en actividades durante la reunión';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementgroup'] = 'Requerir participación';
$string['completionengagementgroup_help'] = 'Se requiere la participación activa durante la sesión para completarla';
$string['completionengagementpollvotes'] = 'Votaciones en la encuesta';
$string['completionengagementtalks'] = 'Eventos de conversación';
$string['completionupdatestate'] = 'Estado de actualización completa';
$string['completionvalidatestate'] = 'Validar finalización';
$string['completionvalidatestatetriggered'] = 'Se ha activado la finalización de la validación.';
$string['config_clienttype'] = 'Configuración del tipo de "cliente web"';
$string['config_clienttype_default'] = 'Tipo de cliente web por defecto';
$string['config_clienttype_default_description'] = 'Elegir entre el cliente clásico Adobe Flash o el nuevo HTML5';
$string['config_clienttype_description'] = 'Esta configuración habilita / deshabilita la opción de cliente web para cada sala.';
$string['config_clienttype_editable'] = 'Se puede editar la elección de cliente web';
$string['config_clienttype_editable_description'] = 'Esta opción permite la elección del cliente web (AdobeFlash / HTML5) desde el formulario de edición de la sala.';
$string['config_default_messages'] = 'Mensajes por defecto';
$string['config_default_messages_description'] = 'Establecer mensajes por defecto para las actividades';
$string['config_disablecam_default'] = 'Desactivar la cámara activada por defecto';
$string['config_disablecam_default_description'] = 'Si se activa, las cámaras web se desactivarán.';
$string['config_disablecam_editable'] = 'Desactivar cámara se puede editar';
$string['config_disablecam_editable_description'] = 'Desactivar cámara se puede editar por defecto cuando se añade o actualiza la instancia.';
$string['config_disablemic_default'] = 'Desactivar micrófono activado por defecto';
$string['config_disablemic_default_description'] = 'Si está habilitado, los micrófonos se desactivarán.';
$string['config_disablemic_editable'] = 'Desactivar micrófono se puede editar';
$string['config_disablemic_editable_description'] = 'Desactivar micrófono se puede editar por defecto cuando se añade o actualiza la instancia.';
$string['config_disablenote_default'] = 'Desactivar notas compartidas que por defecto están habilitadas';
$string['config_disablenote_default_description'] = 'Si está habilitado, las notas compartidas se desactivarán.';
$string['config_disablenote_editable'] = 'Desactivar notas compartidas se puede editar';
$string['config_disablenote_editable_description'] = 'Desactivar notas compartidas se puede editar por defecto cuando se añade o actualiza la instancia.';
$string['config_disableprivatechat_default'] = 'Desactivar chat privado que por defecto está habilitado';
$string['config_disableprivatechat_default_description'] = 'Si está habilitado, el chat privado se desactivará.';
$string['config_disableprivatechat_editable'] = 'Desactivar chat privado se puede editar';
$string['config_disableprivatechat_editable_description'] = 'Desactivar chat privado se puede editar por defecto cuando se añade o actualiza la instancia.';
$string['config_disablepublicchat_default'] = 'Desactivar chat público que por defecto está habilitado';
$string['config_disablepublicchat_default_description'] = 'Si está habilitado, el chat público se desactivará.';
$string['config_disablepublicchat_editable'] = 'Desactivar chat privado se puede editar';
$string['config_disablepublicchat_editable_description'] = 'Desactivar chat público se puede editar por defecto cuando se añade o actualiza la instancia.';
$string['config_experimental_features'] = 'Configuración para características experimentales';
$string['config_experimental_features_description'] = 'Configuración para características experimentales.';
$string['config_extended_capabilities'] = 'Configuración para compatibilidad extendida';
$string['config_extended_capabilities_description'] = 'Configuración para compatibilidad extendida cuando el servidor BigBlueButton lo ofrezca';
$string['config_general'] = 'Configuración general';
$string['config_general_description'] = 'Estas configuraciones son usadas <b>siempre</b>';
$string['config_hideuserlist_default'] = 'Ocultar la lista de usuarios activada por defecto';
$string['config_hideuserlist_default_description'] = 'Si está habilitado, la lista de usuarios de la sesión se ocultará.';
$string['config_hideuserlist_editable'] = 'El hecho de ocultad la lista de usuarios se puede modificar';
$string['config_hideuserlist_editable_description'] = 'Ocultar la lista de usuarios por defecto puede editarse cuando se añade o actualiza la instancia.';
$string['config_importrecordings'] = 'Configuración para la funcionalidad de "Importar grabaciones"';
$string['config_importrecordings_description'] = 'Estos ajustes son específicos de esta funcionalidad';
$string['config_importrecordings_enabled'] = 'Activar importación de grabaciones';
$string['config_importrecordings_enabled_description'] = 'Cuando esto y la función de grabación están habilitadas, es posible importar grabaciones de diferentes cursos a una actividad.';
$string['config_importrecordings_from_deleted_enabled'] = 'Activada importación de grabaciones de actividades eliminadas';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Cuando esto y la función de importación de grabaciones están habilitadas, es posible importar grabaciones de actividades que ya no están en el curso.';
$string['config_lockonjoin_default'] = 'Ignorar bloqueo al unirse, que por defecto está habilitado';
$string['config_lockonjoin_default_description'] = 'Si está habilitado, se ignorarán los ajustes de bloqueo. La configuración de bloqueo debe estar habilitada para que esto se aplique.';
$string['config_lockonjoin_editable'] = 'Ignorar bloqueo al unirse se puede editar';
$string['config_lockonjoin_editable_description'] = 'Ignorar bloqueo al unirse se puede editar por defecto cuando se añade o actualiza la instancia.';
$string['config_locksettings'] = 'Configuración de los ajustes de bloqueo';
$string['config_locksettings_description'] = 'Estos ajustes activan o desactivan las opciones de la interfaz de usuario para los ajustes de bloqueo, y también definen los valores por defecto para estas opciones.';
$string['config_meetingevents_enabled'] = 'Registrar eventos en vivo';
$string['config_meetingevents_enabled_description'] = 'Habilitar el complemento para aceptar y procesar eventos en vivo después de que finalice la sesión. (Esta característica es experimental y solo funcionará si el servidor de BigBlueButton es capaz de procesar scripts posteriores a eventos)';
$string['config_muteonstart'] = 'Configuración de la funcionalidad "Silenciar al iniciar"';
$string['config_muteonstart_default'] = 'Silenciar al inicio habilitado de forma predeterminada';
$string['config_muteonstart_default_description'] = 'Si está habilitado, la sesión se silenciará al inicio.';
$string['config_muteonstart_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la interfaz de usuario y también definen valores predeterminados para estas opciones.';
$string['config_muteonstart_editable'] = 'Silenciar al inicio se puede editar';
$string['config_muteonstart_editable_description'] = 'Silenciar al inicio de forma predeterminada se puede editar cuando se agrega o actualiza la instancia.';
$string['config_participant'] = 'Configuración del participante';
$string['config_participant_description'] = 'Esta configuración define el rol de forma predeterminada para los participantes en una conferencia.';
$string['config_participant_moderator_default'] = 'Moderador por defecto';
$string['config_participant_moderator_default_description'] = 'Esta regla se usa de forma predeterminada cuando se agrega una nueva sala.';
$string['config_presentation_default'] = 'Archivo predeterminado para la función "Presentación previa a la carga"';
$string['config_presentation_default_description'] = 'Esta configuración permite seleccionar un archivo para usar como predeterminado en todas las instancias de BBB si la "Presentación previa a la carga" está habilitada.';
$string['config_preuploadpresentation'] = 'Configuración de la función "Presentación previa a la carga"';
$string['config_preuploadpresentation_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la interfaz de usuario y también definen valores predeterminados para estas opciones. La función solo funciona si el servidor Moodle es accesible para BigBlueButton ..';
$string['config_preuploadpresentation_editable'] = 'Presentación previa a la carga editable';
$string['config_preuploadpresentation_editable_description'] = 'La función de carga previa de la presentación se puede editar en la Interfaz de Usuario cuando se añade o actualiza la sala o la conferencia.';
$string['config_recording'] = 'Configuración para la función "Grabar reunión"';
$string['config_recording_all_from_start_default'] = 'Grabar todo desde el principio';
$string['config_recording_all_from_start_default_description'] = 'Si está seleccionado, la reunión se grabará para comenzar.';
$string['config_recording_all_from_start_editable'] = 'Grabar todo desde el principio se puede editar';
$string['config_recording_all_from_start_editable_description'] = 'Si se marca, la interfaz incluye una opción para habilitar y deshabilitar la función de grabar todo desde el inicio.';
$string['config_recording_default'] = 'Función de grabación habilitada de forma predeterminada';
$string['config_recording_default_description'] = 'Si está habilitado, las sesiones creadas en BigBlueButton podrán grabarse.';
$string['config_recording_description'] = 'Estos ajustes son específicos de esta funcionalidad';
$string['config_recording_editable'] = 'La función de grabación se puede editar';
$string['config_recording_editable_description'] = 'Si se marca, la interfaz incluye una opción para habilitar y deshabilitar la función de grabación.';
$string['config_recording_hide_button_default'] = 'Ocultar el botón de grabación';
$string['config_recording_hide_button_default_description'] = 'Si está marcado, el botón para grabar se ocultará';
$string['config_recording_hide_button_editable'] = 'Ocultar el botón de grabación se puede editar';
$string['config_recording_hide_button_editable_description'] = 'Si está marcada, la interfaz incluye una opción para habilitar y deshabilitar la función de ocultar el botón de grabación.';
$string['config_recordingready_enabled'] = 'Enviar notificaciones cuando una grabación esté lista';
$string['config_recordingready_enabled_description'] = 'Habilitar el complemento para enviar notificaciones cuando la grabación esté lista. (Solo funcionará si el script post_publish_recording_ready_callback está habilitado en el servidor de BigBlueButton)';
$string['config_recordings'] = 'Configuración de la función "Mostrar grabaciones"';
$string['config_recordings_deleted_default'] = 'Incluir grabaciones de actividades eliminadas habilitadas de forma predeterminada';
$string['config_recordings_deleted_default_description'] = 'Si está habilitada, la tabla de grabación incluirá las grabaciones pertenecientes a actividades eliminadas, si las hay.';
$string['config_recordings_deleted_editable'] = 'Incluir grabaciones de la función de actividades eliminadas se puede editar';
$string['config_recordings_deleted_editable_description'] = 'Incluir grabaciones de actividades eliminadas de forma predeterminada se puede editar cuando se agrega o actualiza la instancia.';
$string['config_recordings_description'] = 'Estos ajustes son específicos de la función';
$string['config_recordings_general'] = 'Mostrar configuración de grabación';
$string['config_recordings_general_description'] = 'Estos ajustes se utilizan solo cuando se muestran grabaciones';
$string['config_recordings_html_default'] = 'La interfaz de usuario está habilitada como html de forma predeterminada';
$string['config_recordings_html_default_description'] = 'Si está habilitado, la tabla de grabación se muestra en HTML sin formato de forma predeterminada.';
$string['config_recordings_html_editable'] = 'La interfaz de usuario como función html se puede editar';
$string['config_recordings_html_editable_description'] = 'La interfaz de usuario como valor html de forma predeterminada se puede editar cuando se agrega o actualiza la instancia.';
$string['config_recordings_imported_default'] = 'Mostrar solo los enlaces importados habilitados de forma predeterminada';
$string['config_recordings_imported_default_description'] = 'Si está habilitada, la tabla de grabación incluirá solo los enlaces importados a las grabaciones.';
$string['config_recordings_imported_editable'] = 'Mostrar solo la función de enlaces importados se puede editar';
$string['config_recordings_imported_editable_description'] = 'Mostrar solo los enlaces importados de forma predeterminada se puede editar cuando se agrega o actualiza la instancia.';
$string['config_recordings_preview_default'] = 'La vista previa está habilitada de forma predeterminada';
$string['config_recordings_preview_default_description'] = 'Si está habilitado, la tabla incluye una vista previa de la presentación.';
$string['config_recordings_preview_editable'] = 'La función de vista previa se puede editar';
$string['config_recordings_preview_editable_description'] = 'La función de vista previa se puede editar cuando se agrega o actualiza la instancia.';
$string['config_recordings_sortorder'] = 'Ordenar las grabaciones en orden ascendente.';
$string['config_recordings_sortorder_description'] = 'Por defecto, las grabaciones se muestran en orden descendente. Cuando se marca, se ordenarán en orden ascendente.';
$string['config_recordings_validate_url'] = 'Validar URL';
$string['config_recordings_validate_url_description'] = 'Si está marcada, la URL de reproducción se validará antes de que el usuario acceda a ella.';
$string['config_scheduled'] = 'Configuración para "Sesiones programadas"';
$string['config_scheduled_description'] = 'Estas configuraciones definen algunos de los comportamientos por defecto para las sesiones programadas.';
$string['config_scheduled_duration_compensation'] = 'Tiempo compensatorio (minutos)';
$string['config_scheduled_duration_compensation_description'] = 'Minutos añadidos al cierre agendado al calcular la duración.';
$string['config_scheduled_duration_enabled'] = 'Calcular duración habilitada';
$string['config_scheduled_duration_enabled_description'] = 'La duración de una sesión programada es calculada basándose en las horas de apertura y cierre.';
$string['config_scheduled_pre_opening'] = 'Accesible antes de la hora de apertura (minutos)';
$string['config_scheduled_pre_opening_description'] = 'El tiempo en minutos para que la sesión sea accesible antes de que sea la hora de apertura programada.';
$string['config_sendnotifications'] = 'Configuración de la función "Enviar notificaciones"';
$string['config_sendnotifications_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la interfaz de usuario y también definen valores predeterminados para estas opciones.';
$string['config_sendnotifications_enabled'] = 'Enviar notificaciones habilitado';
$string['config_sendnotifications_enabled_description'] = 'Si está habilitada, la interfaz de usuario para editar la actividad incluye una opción para enviar una notificación al usuario inscrito cuando se agrega o actualiza la actividad.';
$string['config_server_url'] = 'URL del servidor BigBlueButton';
$string['config_server_url_description'] = 'La URL de su servidor BigBlueButton debe terminar en  /bigbluebutton/. (Esta URL por defecto es para un servidor BigBlueButton proporcionado por Blindside Networks que Usted puede usar para pruebas.)';
$string['config_shared_secret'] = 'Clave secreta de BigBlueButton';
$string['config_shared_secret_description'] = 'La sal de seguridad de su servidor BigBlueButton. (esta sal por defecto es para un servidor BigBlueButton proporcionado por Blindside Networks que Usted puede usar para pruebas.)';
$string['config_uidelegation_enabled'] = 'La delegación de interfaz de usuario está habilitada';
$string['config_uidelegation_enabled_description'] = 'Esta configuración habilita o deshabilita la delegación de interfaz de usuario al servidor de BigBlueButton.';
$string['config_userlimit'] = 'Configuración de la función "Límite de usuarios"';
$string['config_userlimit_default'] = 'Límite de usuarios habilitado de forma predeterminada';
$string['config_userlimit_default_description'] = 'Número de usuarios permitidos en una sesión de forma predeterminada cuando se agrega una nueva sala o conferencia. Si el número se establece en 0, no se establece ningún límite';
$string['config_userlimit_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la interfaz de usuario y también definen valores predeterminados para estas opciones.';
$string['config_userlimit_editable'] = 'La función de límite de usuario se puede editar';
$string['config_userlimit_editable_description'] = 'El valor límite de usuario de forma predeterminada se puede editar cuando se agrega o actualiza la sala o la conferencia.';
$string['config_voicebridge'] = 'Configuración de la función "Puente de voz"';
$string['config_voicebridge_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la interfaz de usuario y también definen valores predeterminados para estas opciones.';
$string['config_voicebridge_editable'] = 'El puente de voz de la conferencia se puede editar';
$string['config_voicebridge_editable_description'] = 'El número de puente de voz de conferencia se puede asignar permanentemente a una conferencia de sala. Cuando se asigna, el número no puede ser utilizado por ninguna otra sala o conferencia.';
$string['config_waitformoderator'] = 'Configuración de la función "Esperar al moderador"';
$string['config_waitformoderator_cache_ttl'] = 'Esperar la caché TTL del moderador (segundos)';
$string['config_waitformoderator_cache_ttl_description'] = 'Para admitir una gran carga de clientes, este plugin utiliza un caché. Este parámetro define el tiempo que se mantendrá la caché antes de que se envíe la siguiente solicitud al servidor de BigBlueButton.';
$string['config_waitformoderator_default'] = 'Espera a que el moderador esté habilitado por defecto';
$string['config_waitformoderator_default_description'] = 'La función Esperar al moderador está habilitada de forma predeterminada cuando se agrega una nueva sala o conferencia.';
$string['config_waitformoderator_description'] = 'Estos ajustes son específicos de la función';
$string['config_waitformoderator_editable'] = 'Se puede editar la función Esperar al moderador';
$string['config_waitformoderator_editable_description'] = 'Esperar al valor del moderador por defecto se puede editar cuando se agrega o actualiza la sala o conferencia.';
$string['config_waitformoderator_ping_interval'] = 'Esperar el ping del moderador (segundos)';
$string['config_waitformoderator_ping_interval_description'] = 'Cuando la función de esperar al moderador está habilitada, el cliente hace ping para conocer el estado de la sesión cada [número] segundos. Este parámetro define el intervalo para las solicitudes realizadas al servidor Moodle.';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButtonBN está utilizando config.php con una variable global que ha quedado obsoleta. Convierta el archivo, ya que no será compatible con versiones futuras.';
$string['config_warning_curl_not_installed'] = 'Esta función requiere que la extensión CURL para php  se encuentre instalada y habilitada. La configuración de estos parameteros será posible solo si esta condición se cumple.';
$string['config_welcome_default'] = 'Mensaje de bienvenida por defecto';
$string['config_welcome_default_description'] = 'Reemplaza el mensaje por defecto configurado para el servidor BigBlueButton. El mensaje puede incluir palabras clave (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) que serán sustituidas automáticamente, y también etiquetas html como <b>...</b> o <i></i>';
$string['config_welcome_editable'] = 'Los profesores pueden editar el mensaje de bienvenida predeterminado';
$string['config_welcome_editable_description'] = 'El mensaje de bienvenida puede editarse cuando se crea o se actualiza la instancia';
$string['email_body_notification_meeting_by'] = 'por';
$string['email_body_notification_meeting_description'] = 'Descripción';
$string['email_body_notification_meeting_details'] = 'Detalles';
$string['email_body_notification_meeting_end_date'] = 'Fecha de finalización';
$string['email_body_notification_meeting_has_been'] = 'ha sido';
$string['email_body_notification_meeting_start_date'] = 'Fecha de inicio';
$string['email_body_notification_meeting_title'] = 'Título';
$string['email_body_recording_ready_for'] = 'Grabado por';
$string['email_body_recording_ready_is_ready'] = 'está listo';
$string['email_footer_sent_by'] = 'Esta notificación automática fue enviada por';
$string['email_footer_sent_from'] = 'del curso';
$string['ends_at'] = 'Finales';
$string['event_activity_created'] = 'Actividad creada';
$string['event_activity_deleted'] = 'Actividad eliminada';
$string['event_activity_updated'] = 'Actividad actualizada';
$string['event_activity_viewed'] = 'Actividad visualizada';
$string['event_live_session'] = 'Evento de sesión en vivo';
$string['event_meeting_created'] = 'Sala creada';
$string['event_meeting_ended'] = 'Se ha finalizado la sesión de forma deliberada';
$string['event_meeting_joined'] = 'Se ha unido a una sala';
$string['event_meeting_left'] = 'Ha abandonado la sesión';
$string['event_recording_deleted'] = 'Grabación borrada';
$string['event_recording_edited'] = 'Grabación editada';
$string['event_recording_imported'] = 'Grabación importada';
$string['event_recording_protected'] = 'Grabación protegida';
$string['event_recording_published'] = 'Grabación publicada';
$string['event_recording_unprotected'] = 'Grabación desprotegida';
$string['event_recording_unpublished'] = 'Grabación no publicada';
$string['event_recording_viewed'] = 'Grabación vista';
$string['general_error_not_allowed_to_create_instances'] = 'El usuario no puede crear ningún tipo de instancias.';
$string['general_error_unable_connect'] = 'Incapaz de conectar. Por favor, compruebe la URL del servidor de BigBlueButton y compruebe si el servidor de BigBlueButton está funcionando.';
$string['index_confirm_end'] = '¿Desea terminar la clase virtual?';
$string['index_disabled'] = 'deshabilitada';
$string['index_enabled'] = 'habilitada';
$string['index_ending'] = 'Finalizando la sala virtual....por favor espere';
$string['index_error_bbtn'] = 'El ID de BigBlueButton {$a} es incorrecto';
$string['index_error_checksum'] = 'Ha ocurrido en error en la suma de comprobación. Asegúrese de que ha introducido la sal correcta.';
$string['index_error_forciblyended'] = 'Incapaz de unirse a esta sesión porque ha sido terminada manualmente.';
$string['index_error_noinstances'] = 'No hay instancias de BigBlueButton';
$string['index_error_unable_display'] = 'Incapaz de mostrar las sesiones. Por favor, compruebe la URL del servidor de BigBlueButton y compruebe si el servidor de BigBlueButton está funcionando.';
$string['index_heading'] = 'Salas BigBlueButton';
$string['index_heading_actions'] = 'Acciones';
$string['index_heading_group'] = 'Grupo';
$string['index_heading_moderator'] = 'Moderadores';
$string['index_heading_name'] = 'Sala';
$string['index_heading_recording'] = 'Grabación';
$string['index_heading_users'] = 'Usuarios';
$string['index_heading_viewer'] = 'Asistentes';
$string['indicator:cognitivedepth'] = 'BigBlueButtonBN cognitiva';
$string['indicator:cognitivedepth_help'] = 'Este indicador se basa en la profundidad cognitiva alcanzada por el alumno en una actividad de BigBlueButtonBN.';
$string['indicator:socialbreadth'] = 'BigBlueButtonBN social';
$string['indicator:socialbreadth_help'] = 'Este indicador se basa en la amplitud social alcanzada por el alumno en una actividad de BigBlueButtonBN.';
$string['instance_type_default'] = 'Sala/Actividad con grabaciones';
$string['instance_type_recording_only'] = 'Solo grabaciones';
$string['instance_type_room_only'] = 'Solo salas/actividad';
$string['minute'] = 'minuto';
$string['minutes'] = 'minutos';
$string['mod_form_block_clienttype'] = 'Tecnología de cliente web';
$string['mod_form_block_clienttype_flash'] = 'Cliente basado en tecnología Adobe Flash';
$string['mod_form_block_clienttype_html5'] = 'Cliente basado en tecnología HTML5';
$string['mod_form_block_general'] = 'Ajustes generales';
$string['mod_form_block_participants'] = 'Rol asignado durante la sesión en vivo';
$string['mod_form_block_presentation'] = 'Presentación de contenido';
$string['mod_form_block_presentation_default'] = 'Contenido predeterminado de la presentación';
$string['mod_form_block_record'] = 'Ajustes de grabación.';
$string['mod_form_block_recordings'] = 'Ver para grabar';
$string['mod_form_block_room'] = 'Configuración de actividad/sala';
$string['mod_form_block_schedule'] = 'Programación de sesiones';
$string['mod_form_field_block_clienttype'] = 'Tecnología de cliente web';
$string['mod_form_field_closingtime'] = 'Accesso cerrado';
$string['mod_form_field_conference_name'] = 'Nombre de conferencia';
$string['mod_form_field_disablecam'] = 'Desactivar las cámaras web';
$string['mod_form_field_disablemic'] = 'Desactivar los micrófonos';
$string['mod_form_field_disablenote'] = 'Desactivar las notas compartidas';
$string['mod_form_field_disableprivatechat'] = 'Desactivar el chat privado';
$string['mod_form_field_disablepublicchat'] = 'Desactivar el chat público';
$string['mod_form_field_duration'] = 'Duración';
$string['mod_form_field_duration_help'] = 'Fijar la duración para una sesión establecerá el tiempo máximo para mantener activa una sesión antes de que termine la grabación';
$string['mod_form_field_hideuserlist'] = 'Ocultar la lista de usuarios';
$string['mod_form_field_instanceprofiles'] = 'Tipo de instancia';
$string['mod_form_field_instanceprofiles_help'] = 'Elegir el tipo para esta instancia de BigBlueButtonBN';
$string['mod_form_field_intro'] = 'Descripción';
$string['mod_form_field_intro_help'] = 'Descripción corta para la sala o conferencia.';
$string['mod_form_field_lockonjoin'] = 'Ignorar los ajustes de bloqueo';
$string['mod_form_field_muteonstart'] = 'Silenciar al comenzar';
$string['mod_form_field_name'] = 'Nombre de la sala virtual';
$string['mod_form_field_nosettings'] = 'No se puede editar ninguna configuración';
$string['mod_form_field_notification'] = 'Notificar este cambio a los usuarios inscritos';
$string['mod_form_field_notification_created_help'] = 'Enviar una notificación a todos los usuarios inscritos para que sepan que se ha creado esta actividad';
$string['mod_form_field_notification_help'] = 'Enviar una notificación a todos los usuarios inscritos para informarles de que esta actividad se ha añadido o actualizado';
$string['mod_form_field_notification_modified_help'] = 'Enviar una notificación a todos los usuarios inscritos para que sepan que esta actividad ha sido actualizada';
$string['mod_form_field_notification_msg_at'] = 'en';
$string['mod_form_field_notification_msg_created'] = 'añadida';
$string['mod_form_field_notification_msg_modified'] = 'actualizada';
$string['mod_form_field_openingtime'] = 'Acceso abierto';
$string['mod_form_field_participant_add'] = 'Agregar participante';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderador';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Observador';
$string['mod_form_field_participant_list'] = 'Lista de participantes';
$string['mod_form_field_participant_list_action_add'] = 'Agregar';
$string['mod_form_field_participant_list_action_remove'] = 'Eliminar';
$string['mod_form_field_participant_list_text_as'] = 'entra en la sesión como';
$string['mod_form_field_participant_list_type_all'] = 'Todos los usuarios inscritos';
$string['mod_form_field_participant_list_type_owner'] = 'Responsable';
$string['mod_form_field_participant_list_type_role'] = 'Rol';
$string['mod_form_field_participant_list_type_user'] = 'Usuario';
$string['mod_form_field_record'] = 'La sesión puede ser grabada';
$string['mod_form_field_recordallfromstart'] = 'Grabar todo desde el principio';
$string['mod_form_field_recordhidebutton'] = 'Ocultar botón de grabación';
$string['mod_form_field_recordings_deleted'] = 'Incluir grabaciones de actividades eliminadas';
$string['mod_form_field_recordings_html'] = 'Mostrar la tabla en HTML simple';
$string['mod_form_field_recordings_imported'] = 'Mostrar solo enlaces importados';
$string['mod_form_field_recordings_preview'] = 'Mostrar vista previa de grabación';
$string['mod_form_field_room_name'] = 'Nombre de la sala';
$string['mod_form_field_userlimit'] = 'Límite de usuarios';
$string['mod_form_field_userlimit_help'] = 'Límite máximo de usuarios permitidos en una reunión. Si el límite está a 0 el número de usuarios será ilimitado.';
$string['mod_form_field_voicebridge'] = 'Puente de voz [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Error de formato. Debe introducir un número entre 1 y 9999.';
$string['mod_form_field_voicebridge_help'] = 'Número de la conferencia de voz que los participantes introducen para unirse a la conferencia de voz cuando se utiliza la marcación. Debe introducirse un número entre 1 y 9999. Si el valor es 0, el número estático de voicebridge será ignorado y un número aleatorio será generado por BigBlueButton. Un número 7 precederá a los cuatro dígitos tecleados';
$string['mod_form_field_voicebridge_notunique_error'] = 'No es un valor único. Este numero ha sido usado por otra sala o conferencia.';
$string['mod_form_field_wait'] = 'Esperar al moderaror';
$string['mod_form_field_wait_help'] = 'Los observadores deben esperar hasta que un moderador entre a la sesión para poder acceder';
$string['mod_form_field_welcome'] = 'Mensaje de bienvenida';
$string['mod_form_field_welcome_default'] = '¡<br>Bienvenido a <b>%%CONFNAME%%</b>!<br><br>Para entender cómo funciona BigBlueButton vea nuestros <a href="event:http://www.bigbluebutton.org/content/videos"><u>vídeotutoriales</u></a>.<br><br>Para unirse al puente de audio pulse en el icono de los auriculares (en la esquina superior izquierda). <b>Por favor, use auriculares para evitar causarle ruido a los demás.</b>';
$string['mod_form_field_welcome_help'] = 'Reemplaza el mensaje por defecto fijado por el servidor de BigBlueButton. El mensaje puede incluir las palabras clave (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) las cuales serán sutituidas automáticamente, y también etiquetas html como <b>...</b> o <i></i>';
$string['mod_form_locksettings'] = 'Ajustes de bloqueo';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButtonBN le permite crear dentro de Moodle enlaces hacia aulas en línea en tiempo real con salas que emplean BigBlueButton, un sistema de código abierto para conferencias web para la educación a distancia.

Usando BigBlueButtonBN puede especificar el título, descripción, fecha del calendario (que le proporciona un rango de fechas para unirse a la sesión), grupos, y detalles acerca de la grabación de la sesión en línea.

Para ver grabaciones posteriormente, añada un recurso RecordingsBN a este curso.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['pluginadministration'] = 'Administración de BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Para crear y unirse a sesiones de BigBlueButton, los datos del usuario deben intercambiarse con el servidor.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'El nombre completo del usuario que accede al servidor de BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'El ID de usuario del usuario que accede al servidor de BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Almacena la configuración de la sala o actividad que define las funciones y el comportamiento general de la sesión de BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Una lista de reglas que definen el rol que tendrán los usuarios en la reunión en vivo. Se puede almacenar una identificación de usuario ya que se pueden otorgar permisos por función o usuario.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Almacena eventos activados cuando se usa el complemento.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'El tipo de evento desencadenado por el usuario.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'El ID de reunión a la que el usuario tiene acceso.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Puede incluir información adicional relacionada con la reunión o la grabación afectada por el evento.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'La hora a la que se creó el registro.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'El ID de usuario del usuario que desencadenó el evento.';
$string['removedevents'] = 'Eventos eliminados';
$string['removedlogs'] = 'Registros personalizados eliminados';
$string['removedrecordings'] = 'Grabaciones eliminadas';
$string['removedtags'] = 'Etiquetas eliminadas';
$string['resetevents'] = 'Eliminar eventos';
$string['resetlogs'] = 'Eliminar registros personalizados';
$string['resetlogs_help'] = 'Eliminar los registros provocará la pérdida de referencias a grabaciones';
$string['resetrecordings'] = 'Eliminar grabaciones';
$string['resetrecordings_help'] = 'Eliminar las grabaciones las hará inaccesibles desde cualquier lugar y no se puede deshacer';
$string['resettags'] = 'Eliminar etiquetas';
$string['search:activity'] = 'BigBlueButtonBN - información de actividad';
$string['search:tags'] = 'BigBlueButtonBN - información de etiquetas';
$string['sendnotification'] = 'Enviar notificación';
$string['started_at'] = 'Empezado';
$string['starts_at'] = 'Empieza';
$string['view_conference_action_end'] = 'Fin de sesión';
$string['view_conference_action_join'] = 'Unirse a la sesión';
$string['view_error_action_not_completed'] = 'La acción no pudo ser completada';
$string['view_error_bigbluebutton'] = 'BigBlueButton respondió con errores. {$a}';
$string['view_error_create'] = 'El servidor BigBlueButton ha respondido con un mensaje de error, la sesión no pudo ser creada.';
$string['view_error_current_state_not_found'] = 'No se encontró el estado actual. Es posible que la grabación se haya eliminado o que el servidor de BigBlueButton no sea compatible con la acción realizada.';
$string['view_error_import_no_courses'] = 'No hay cursos para buscar grabaciones';
$string['view_error_import_no_recordings'] = 'No hay grabaciones en este curso para importar';
$string['view_error_invalid_session'] = 'La sesión ha caducado. Vuelve a la página principal de la actividad.';
$string['view_error_max_concurrent'] = 'El máximo número de sesiones concurrentes permitido ha sido alcanzado.';
$string['view_error_meeting_not_running'] = 'Algo salió mal, la reunión no se está ejecutando.';
$string['view_error_no_group'] = 'Aún no hay grupos configurados. Por favor, establezca los grupos antes de intentar unirse a una sesión.';
$string['view_error_no_group_student'] = 'No has sido enrolado a ningún grupo. Por favor, contacte con su profesor con el administrador.';
$string['view_error_no_group_teacher'] = 'Aún no hay grupos configurados. Por favor, establezca los grupos o contacte con el administrador.';
$string['view_error_unable_join'] = 'Incapaz de unirse a la sesión. Por favor compruebe la URL del servidor de BigBlueButton y compruebe que el servidor de BigBlueButton está en funcionamiento.';
$string['view_error_unable_join_student'] = 'Incapáz de conectarse al servidor de BigBlueButton. Por favor, póngase en contacto con su profesor o con el administrador.';
$string['view_error_unable_join_teacher'] = 'Incapáz de conectarse al servidor de BigBlueButton. Por favor, póngase en contacto con el administrador.';
$string['view_error_url_missing_parameters'] = 'Faltan parámetros en esta URL';
$string['view_error_userlimit_reached'] = 'El número de usuarios permitido en una reunión ha sido alcanzado.';
$string['view_groups_nogroups_warning'] = 'La sala se configuró para usar grupos pero el curso no tiene grupos definidos.';
$string['view_groups_notenrolled_warning'] = 'La sala se configuró para usar grupos, pero no está inscripto en ninguno de ellos.';
$string['view_groups_selection'] = 'Seleccione el grupo al que desea unirse y confirme la acción';
$string['view_groups_selection_join'] = 'Ingresar';
$string['view_groups_selection_warning'] = 'Hay una sala de conferencia para cada grupo, Si Usted tiene acceso a más de una, asegúrese de seleccionar la sala correcta.';
$string['view_login_moderator'] = 'Accediendo como moderador...';
$string['view_login_viewer'] = 'Accediendo como asistente...';
$string['view_message_and'] = 'y';
$string['view_message_conference_has_ended'] = 'Esta conferencia ha terminado';
$string['view_message_conference_in_progress'] = 'Esta conferencia está en proceso.';
$string['view_message_conference_not_started'] = 'Esta conferencia no ha comenzado todavía.';
$string['view_message_conference_room_ready'] = 'Esta sala de conferencia está lista. Puede unirse a la sesión ahora.';
$string['view_message_conference_wait_for_moderator'] = 'Esperando por un moderador para unirse.';
$string['view_message_finished'] = 'Esta actividad finalizó.';
$string['view_message_has_joined'] = 'se ha unido';
$string['view_message_have_joined'] = 'se han unido';
$string['view_message_hour'] = 'hora';
$string['view_message_hours'] = 'horas';
$string['view_message_importrecordings_disabled'] = 'La función para importar enlaces de grabación está deshabilitada en este servidor.';
$string['view_message_minute'] = 'minuto';
$string['view_message_minutes'] = 'minutos';
$string['view_message_moderator'] = 'moderador';
$string['view_message_moderators'] = 'moderadores';
$string['view_message_norecordings'] = 'No hay ninguna grabación que mostrar.';
$string['view_message_notavailableyet'] = 'Esta sesión aun no está disponible.';
$string['view_message_recordings_disabled'] = 'Las grabaciones se desactivaron en este servidor. No se pueden utilizar instancias de BigBlueButtonBN solo para grabaciones.';
$string['view_message_room_closed'] = 'Esta sala está cerrada.';
$string['view_message_room_open'] = 'Esta sala está abierta.';
$string['view_message_room_ready'] = 'Esta sala está lista.';
$string['view_message_session_for'] = 'la sesión para';
$string['view_message_session_has_user'] = 'Hay';
$string['view_message_session_has_users'] = 'Hay';
$string['view_message_session_no_users'] = 'No hay usuarios en esta sesión';
$string['view_message_session_running_for'] = 'Esta sesión ha estado activa por';
$string['view_message_session_started_at'] = 'Esta sesión inició a las';
$string['view_message_tab_close'] = 'Esta pestaña/ventana debe ser cerrada manualmente';
$string['view_message_times'] = 'tiempos';
$string['view_message_user'] = 'usuario';
$string['view_message_users'] = 'usuarios';
$string['view_message_viewer'] = 'observador';
$string['view_message_viewers'] = 'observadores';
$string['view_mobile_message_groups_not_supported'] = 'Esta instancia está habilitada para trabajar con grupos, pero la aplicación móvil no es compatible con esto. Abra en el escritorio si desea utilizar el soporte grupal.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Excedió los 45 segundos en esta página, vuelva a cargar la página para unirse correctamente a la reunión.';
$string['view_noguests'] = 'El módulo BigBlueButton no está abierto para invitados';
$string['view_nojoin'] = 'No estás en un rol con permiso para unirse a esta sesión.';
$string['view_recording'] = 'grabación';
$string['view_recording_actionbar'] = 'Barra de herramienta';
$string['view_recording_activity'] = 'Actividad';
$string['view_recording_button_import'] = 'Importar enlaces de grabación';
$string['view_recording_button_return'] = 'Ir atrás';
$string['view_recording_course'] = 'Curso';
$string['view_recording_date'] = 'Fecha';
$string['view_recording_delete_confirmation'] = '¿Está seguro de eliminar {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Esta grabación tiene {$a} enlaces asociados que fueron importados en diferentes cursos o actividades. Si se elimina la grabación, esos enlaces también se eliminarán.';
$string['view_recording_delete_confirmation_warning_s'] = 'Esta grabación tiene un enlace {$a} asociado que se importó en un curso o actividad diferente. Si se elimina la grabación, ese enlace también se eliminará';
$string['view_recording_description'] = 'Descripción';
$string['view_recording_duration'] = 'Duración';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'No se puede acceder a la URL de este formato de grabación.';
$string['view_recording_format_notes'] = 'Anotaciones';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Presentación';
$string['view_recording_format_screenshare'] = 'Compartir pantalla';
$string['view_recording_format_statistics'] = 'Estadísticas';
$string['view_recording_format_video'] = 'Vídeo';
$string['view_recording_import_confirmation'] = '¿Estás seguro de importar esta grabación?';
$string['view_recording_length'] = 'Duración';
$string['view_recording_link'] = 'Enlace importado';
$string['view_recording_link_warning'] = 'Este es un enlace que apunta a una grabación que se creó en un curso o actividad diferente';
$string['view_recording_list_action_delete'] = 'Borrando';
$string['view_recording_list_action_edit'] = 'Actualizando';
$string['view_recording_list_action_play'] = 'Reproducir';
$string['view_recording_list_action_process'] = 'Procesando';
$string['view_recording_list_action_protect'] = 'Protegiendo';
$string['view_recording_list_action_publish'] = 'Publicando';
$string['view_recording_list_action_unprotect'] = 'Desprotegiendo';
$string['view_recording_list_action_unpublish'] = 'Despublicando';
$string['view_recording_list_action_update'] = 'Actualizando';
$string['view_recording_list_actionbar'] = 'Barra de herramientas';
$string['view_recording_list_actionbar_delete'] = 'Eliminar';
$string['view_recording_list_actionbar_edit'] = 'Editar';
$string['view_recording_list_actionbar_hide'] = 'Ocultar';
$string['view_recording_list_actionbar_import'] = 'Importar';
$string['view_recording_list_actionbar_protect'] = 'Hacer privado';
$string['view_recording_list_actionbar_publish'] = 'Publicar';
$string['view_recording_list_actionbar_show'] = 'Mostrar';
$string['view_recording_list_actionbar_unprotect'] = 'Hacer público';
$string['view_recording_list_actionbar_unpublish'] = 'Despublicar';
$string['view_recording_list_activity'] = 'Actividad';
$string['view_recording_list_course'] = 'Curso';
$string['view_recording_list_date'] = 'Fecha';
$string['view_recording_list_description'] = 'Descripción';
$string['view_recording_list_duration'] = 'Duración';
$string['view_recording_list_recording'] = 'Grabación';
$string['view_recording_meeting'] = 'Reunión';
$string['view_recording_modal_button'] = 'Aplicar';
$string['view_recording_modal_title'] = 'Coloque valores para grabación';
$string['view_recording_name'] = 'Nombre';
$string['view_recording_playback'] = 'Reproducción';
$string['view_recording_preview'] = 'Vista preliminar';
$string['view_recording_preview_help'] = 'Colocar el cursor sobre una imagen para verla en tamaño completo';
$string['view_recording_publish_link_deleted'] = 'Este enlace no se puede volver a publicar porque la grabación real no existe en el servidor BigBlueButton actual. El enlace debe eliminarse.';
$string['view_recording_publish_link_not_published'] = 'Este enlace no se puede volver a publicar porque la grabación real no está publicada.';
$string['view_recording_recording'] = 'Grabando';
$string['view_recording_tags'] = 'Etiquetas';
$string['view_recording_unprotect_link_deleted'] = 'Este enlace no puede desprotegerse porque la grabación real no existe en el servidor BigBlueButton actual. El enlace debe eliminarse.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Este enlace no se puede desproteger porque la grabación real está protegida';
$string['view_recording_unpublish_confirmation'] = '¿Estás seguro de anular la publicación de {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Esta grabación tiene {$a} enlaces asociados que fueron importados en diferentes cursos o actividades. Si la grabación no se publica, esos enlaces también se cancelarán.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Esta grabación tiene un enlace {$a} asociado que se importó en un curso o actividad diferente. Si se anula la publicación de la grabación, ese enlace también se anulará.';
$string['view_recording_yui_first'] = 'Primero';
$string['view_recording_yui_go'] = 'Ir';
$string['view_recording_yui_last'] = 'Último';
$string['view_recording_yui_next'] = 'Siguiente';
$string['view_recording_yui_page'] = 'Página';
$string['view_recording_yui_prev'] = 'Anterior';
$string['view_recording_yui_rows'] = 'Filas';
$string['view_recording_yui_show_all'] = 'Mostrar todo';
$string['view_room'] = 'Ver sala';
$string['view_section_title_presentation'] = 'Archivo de presentación';
$string['view_section_title_recordings'] = 'Grabaciones';
$string['view_warning_default_server'] = 'Este servidor Moodle está utilizando el servidor de pruebas BigBlueButton que viene preconfigurado por defecto. Debería ser reemplazado para la producción.';
